package com.cusc.nirvana.user.rnr.mg.constants;

/**
 * Description: 系统编码
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum SystemCodeEnum {

    OLD_RNR(1, "老实名"),
    V_PLATFORM(2, "V平台"),
    ;

    private int code;
    private String name;

    SystemCodeEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static SystemCodeEnum getEnumByCode(int code) {
        for (SystemCodeEnum sys : SystemCodeEnum.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
