package com.cusc.nirvana.user.rnr.mg.constants;

/**
 * Description: 实名状态
 * <br />
 * CreateDate 2022-04-19 20:51:07
 *
 * @author yuyi
 **/
public enum RnrStatus {
    INIT(0, "未实名/初始化"),
    RNR(1, "已实名"),
    RNR_FAIL(2, "实名失败"),
    UNBOUND(3, "已解绑"),
    UNBOUNDING(6,"解绑中"),
    ARTIFICIAL_RNRING(4,"人工认证中"),
    AUTOMATIC_RNRING(5,"自动认证中");

    private int code;
    private String comment;

    RnrStatus(int code, String comment) {
        this.code = code;
        this.comment = comment;
    }

    public static RnrStatus getEnumByCode(int code) {
        for (RnrStatus sys : RnrStatus.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getComment() {
        return comment;
    }
}
