package com.cusc.nirvana.user.rnr.mg.constants;

import java.util.Arrays;
import java.util.Optional;

/**
 * Description: 实名订单状态枚举
 * <br />
 * CreateDate 2022-03-03 19:30:36
 *
 * @author yuyi
 **/
public enum RnrOrderStatusEnum {

    COMMIT(0, "已提交 ，待确认"),
    ASSIGNMENT(1, "待分派/认领"),
    TO_EXAMINE(2, "待审核"),
    PASS(3, "审核通过"),
    NOT_PASS(4, "未通过"),
    CANCEL(9, "系统自动审核不通过"),
    EXAMINEING(10,"T1上报中");

    private Integer code;
    private String comment;

    RnrOrderStatusEnum(Integer code, String comment) {
        this.code = code;
        this.comment = comment;
    }

    public static RnrOrderStatusEnum getDescription(Integer key) {
        for (RnrOrderStatusEnum status : values()) {
            if (status.code.equals(key)) {
                return status;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getComment() {
        return comment;
    }

    //判断工单是否结束
    public static boolean notFinished(RnrOrderStatusEnum statusEnum){
        return statusEnum == null || statusEnum == COMMIT  || statusEnum == ASSIGNMENT
                || statusEnum == TO_EXAMINE  || statusEnum == ASSIGNMENT;
    }

    //判断工单是否结束
    public static boolean notFinished(Integer status){
        if(status == null) return true;
        Optional<RnrOrderStatusEnum> first = Arrays.stream(RnrOrderStatusEnum.values()).filter(e -> e.getCode() == status).findFirst();
        return first == null || notFinished(first.get());
    }

}
