package com.cusc.nirvana.user.rnr.mg.constants;

/**
 * Description: 实名类型枚举
 * <br />
 * CreateDate 2022-03-01 14:37:32
 *
 * @author yuyi
 **/
public enum RnrNoticeTypeEnum {

    RNR_SUCCESS("RNR_SUCCESS", "实名成功"),
    RNR_FAIL("RNR_FAIL", "实名失败"),
    UNBOUND_SUCCESS("UNBOUND_SUCCESS", "解绑成功"),
    INFO_CHANGE("INFO_CHANGE", "信息变更");

    private String code;
    private String name;

    RnrNoticeTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static RnrNoticeTypeEnum getEnumByCode(int code) {
        for (RnrNoticeTypeEnum sys : RnrNoticeTypeEnum.values()) {
            if (sys.getCode().equals(code)) {
                return sys;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
