package com.cusc.nirvana.user.rnr.mg.constants;

import java.util.ArrayList;
import java.util.List;

/**
 * Description: 实名文件类型
 * <br />
 * CreateDate 2022-03-03 10:08:34
 *
 * @author yuyi
 **/
public enum RnrFileType {
    IDENTITY_CARD_BACK(1, "身份证人像正面"),
    IDENTITY_CARD_FRONT(2, "身份证国徽反面"),
    LIVENESS_SCREEN_FIRST(3, "活体截图1"),
    LIVENESS_SCREEN_TWO(4, "活体截图2"),
    VEHUCLE_BIND(5, "入网合同"),
    LIVENESS_VIDEO(6, "活体视频"),
    OFFICIAL_CARD_FRONT(8, "中国人民解放军军人身份证件正面"),
    OFFICIAL_CARD_BACK(9, "中国人民解放军军人身份证件反面"),
    POLICE_CARD_FRONT(10, "中国人民武装警察身份证件正面"),
    POLICE_CARD_BACK(11, "中国人民武装警察身份证件反面"),
    HK_MACAO_PASSPORT_FRONT(12, "港澳居民来往内地通行证正面"),
    HK_MACAO_PASSPORT_BACK(13, "港澳居民来往内地通行证反面"),
    TAIWAN_CARD_FRONT(14, "台湾居民来往大陆通行证正面"),
    TAIWAN_CARD_BACK(15, "台湾居民来往大陆通行证反面"),
    FOREIGN_NATIONAL_PASSPORT_FRONT(16, "外国公民护照正面"),
    FOREIGN_NATIONAL_PASSPORT_BACK(17, "外国公民护照反面"),
    HK_MACAO_RESIDENCE_PERMIT_FRONT(18, "港澳居民居住证正面"),
    HK_MACAO_RESIDENCE_PERMIT_BACK(19, "港澳居民居住证反面"),
    TAIWAN_RESIDENCE_PERMIT_FRONT(20, "台湾居民居住证正面"),
    TAIWAN_RESIDENCE_PERMIT_BACK(21, "台湾居民居住证反面"),
    RESIDENCE_BOOKLET_FRONT(22, "户口簿正面"),
    RESIDENCE_BOOKLET_BACK(23, "户口簿反面"),
    CAR_PURCHASE_CONTRACT(24, "购车合同"),
    CAR_PURCHASE_INVOICE(25, "购车发票"),
    CAR_TRANSFER_CERTIFICATE(26, "汽车过户证明"),
    LETTER_ATTORNEY(27, "委托书"),
    ENTERPRISE_PIC(28, "企业证件照片"),
	ENTERPRISE_AUTH_FILE(29,"企业实名认证授权书"),
	UNITCREDITCODE(30,""),
	DUTY_FILE(31,"责任告知书"),
    FOREIGNER_LIVE_CARD_BACK(32,"外国人永久居留证正面"),
    FOREIGNER_LIVE_CARD_FRONT(33,"外国人永久居留证反面"),
	OTHER(99,"其他"),
    ;

    private Integer type;
    private String comment;

    RnrFileType(Integer type, String comment) {
        this.type = type;
        this.comment = comment;
    }

    public static RnrFileType getDescription(Integer key) {
        for (RnrFileType type : values()) {
            if (type.type.equals(key)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return type;
    }

    public String getComment() {
        return comment;
    }

    public static List<Integer> getIdImageFace() {
        List<Integer> list = new ArrayList<>();
        for (RnrFileType fileType : values()) {
            if(-1!=fileType.getComment().indexOf("正面")){
                list.add(fileType.getCode());
            }
        }
        return list;
    }


    public static List<Integer> getIdImageEmblem() {
        List<Integer> list = new ArrayList<>();
        for (RnrFileType fileType : values()) {
            if(-1!=fileType.getComment().indexOf("反面")){
                list.add(fileType.getCode());
            }
        }
        return list;
    }
}
