package com.cusc.nirvana.user.rnr.mg.constants;



/**
 * 运营商类型
 */

public enum MbCodeEnum {
    CMCC("2000", "中国移动", "898600,898602,898604,898607"),
    CUCC("3000", "中国联通", "898601,898606,898609"),
    CTCC("1000", "中国电信", "898603,898611"),
    QT("4000", "其他", "");
    private String code;
    private String name;
    private String codes;
    
    public static MbCodeEnum getEnumByCode(String code) {
        for (MbCodeEnum e : MbCodeEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }
    
    public static MbCodeEnum get(String iccid) {
        for (MbCodeEnum value : MbCodeEnum.values()) {
            String codes = value.getCodes();
            if (codes.indexOf(iccid.substring(0, 6)) != -1) {
                return value;
            }
        }
        return MbCodeEnum.QT;
    }

    MbCodeEnum(String code, String name, String codes) {
        this.code = code;
        this.name = name;
        this.codes = codes;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCodes() {
        return codes;
    }

    public void setCodes(String codes) {
        this.codes = codes;
    }
    

}
