package com.cusc.nirvana.user.rnr.mg.constants;

import static com.cusc.nirvana.user.rnr.mg.constants.RnrFileType.*;

/**
 * Description: 证件类型枚举
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum CertTypeEnum {

    //居民身份证
    IDCARD("IDCARD", "居民身份证", true, IDENTITY_CARD_BACK, IDENTITY_CARD_FRONT),
    HKIDCARD("HKIDCARD", "港澳居民来往内地通行证", true, HK_MACAO_PASSPORT_FRONT, HK_MACAO_PASSPORT_BACK),
    TAIBAOZHENG("TAIBAOZHENG", "台湾居民来往大陆通行证", true, TAIWAN_CARD_FRONT, TAIWAN_CARD_BACK),
    HKRESIDENCECARD("HKRESIDENCECARD","港澳居民居住证",true,HK_MACAO_RESIDENCE_PERMIT_FRONT,HK_MACAO_RESIDENCE_PERMIT_BACK),
    TWRESIDENCECARD("TWRESIDENCECARD","台湾居民居住证",true,TAIWAN_RESIDENCE_PERMIT_FRONT,TAIWAN_RESIDENCE_PERMIT_BACK),
    PASSPORT("PASSPORT", "护照", true, FOREIGN_NATIONAL_PASSPORT_FRONT, FOREIGN_NATIONAL_PASSPORT_BACK),
    PLA("PLAIDCARD", "军官证", true, OFFICIAL_CARD_FRONT, OFFICIAL_CARD_BACK),
    POLICEPAPER("POLICEPAPER", "警官证", true, POLICE_CARD_FRONT, POLICE_CARD_BACK),
    UNITCREDITCODE("0", "统一社会信用代码", false, RnrFileType.UNITCREDITCODE),
    //UNITCREDITCODE("1", "组织机构代码证", false, RnrFileType.UNITCREDITCODE),
    //UNITCREDITCODE("3", "事业单位法人证书或者社会团体法人登记证书", false, RnrFileType.UNITCREDITCODE),
    //    ORGANIZATION_CODE("ORGANIZATION_CODE", "统一社会信用代码"),
    BUSINESS_LICENSE_NO("2", "营业执照号", false, RnrFileType.OTHER),
    SOCIAL_ORG_LEGAL_PERSON_CERT("3", "事业代为法人证书或社会团体法人证书", false, ENTERPRISE_AUTH_FILE),
    RESIDENCE("HOUSEHOLD", "户口簿", true, RESIDENCE_BOOKLET_FRONT, RESIDENCE_BOOKLET_BACK),
    NON_NATIONAL_VALID_CERTIFICATE("NON_NATIONAL_VALID_CERTIFICATE","非国家规定有效证件",false,RnrFileType.OTHER),
    OTHER("OTHER", "其他证件", false, RnrFileType.OTHER),
    FOREIGNERLIVECARD("FOREIGNERLIVECARD", "外国人永久居留证", true, FOREIGNER_LIVE_CARD_BACK, FOREIGNER_LIVE_CARD_FRONT);


//    ,OTHERLICENCE("OTHERLICENCE", "其他", false, RnrFileType.OTHER)

    private String code;
    private String name;
    /**
     * 是否固定文件数量
     */
    private boolean fixedSize;
    private RnrFileType[] fileTypes;

    CertTypeEnum(String code, String name, boolean fixedSize, RnrFileType... fileTypes) {
        this.code = code;
        this.name = name;
        this.fixedSize = fixedSize;
        this.fileTypes = fileTypes;
    }

    public static CertTypeEnum getEnumByCode(String code) {
        for (CertTypeEnum sys : CertTypeEnum.values()) {
            if (sys.getCode().equals(code)) {
                return sys;
            }
        }
        return null;
    }

    public boolean isFixedSize() {
        return fixedSize;
    }

    public RnrFileType[] getFileTypes() {
        return fileTypes;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
