package com.cusc.nirvana.user.rnr.mg.constants;

/**
 * Description: 认证方式类型枚举
 * <br />
 * CreateDate 2022-02-14 15:31:33
 *
 * @author yuyi
 **/
public enum AuthWayTypeEnum {

    CERT_CHECK("CERT_CHECK", "身份信息核查","V0194"),
    ID_COMPARE("ID_COMPARE", "人证比对","V1401"),
    FACE_COMPARE("FACE_COMPARE", "人脸比对","V1402"),
    FMP("FMP", "活体后端校验","V1403"),
    OCR("OCR", "光符识别","V1404"),
    LIVENESS("LIVENESS", "活体检测","V1405"),
    LIVENESS_CODE("LIVENESS_CODE", "活体数字验证码","V1406"),
    ACTION_SEQ("ACTION_SEQ", "活体序列","V1407"),
    CARD_NUM_IOV("CARD_NUM_IOV", "车联网一证十卡","V1408");

    private String code;
    private String name;
    private String type;
    AuthWayTypeEnum(String code, String name,String type) {
        this.code = code;
        this.name = name;
        this.type= type;
    }

    public static AuthWayTypeEnum getEnumByCode(String code) {
        for (AuthWayTypeEnum sys : AuthWayTypeEnum.values()) {
            if (sys.getCode().equals(code)) {
                return sys;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
    
    public String getType() {
        return type;
    }
    
    public static void main(String[] args) {
    	System.out.println(AuthWayTypeEnum.getEnumByCode("CERT_CHECK").getType());
	}

}
