package com.cusc.nirvana.user.rnr.mg.common;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotBlank;

@Data
public class BaseApiFawRnrUrlDTO implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 组织ID
     */
    @NotBlank(
            message = "组织ID不能为空"
    )
    @ApiModelProperty(value = "组织ID")
    private String orgId;

    @NotBlank(
            message = "流水号不能为空"
    )
    @ApiModelProperty(value = "请求流水号")
    private String serialNumber;
    
    
    @NotBlank(
            message = "实名类型不能为空"
    )
    @ApiModelProperty(value = "实名类型")
    private String authType;

  
}
