package com.cusc.nirvana.user.rnr.mg.common;

import com.cusc.nirvana.user.rnr.mg.dto.SimInfoDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;
import java.util.Date;
import java.util.List;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;

/**
 * <p>
 * iam的DO基类
 * </p>
 *
 * @author yuyi
 * @since 2021-10-21
 */
@Data
public class BaseApiAuthStateDTO implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 组织ID
     */
    @NotBlank(
            message = "组织ID不能为空"
    )
    @ApiModelProperty(value = "组织ID")
    private String orgId;

    @NotBlank(
            message = "流水号不能为空"
    )
    @ApiModelProperty(value = "请求流水号")
    private String serialNumber;

    @NotEmpty(message = "iccid不能为空")
    private List<SimInfoDTO> simInfoList;

  
}
