package com.cusc.nirvana.user.rnr.mg.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 实名关系信息表对象类
 *
 * @author yuy336
 * @since 2022-02-10 18:28:52
 */
@ApiModel(value = "实名关系信息表", description = "实名关系信息表")
@Data
public class RnrRelationDTO implements Serializable {

    private static final long serialVersionUID = -31644503457036551L;

    @ApiModelProperty(value = "随机数")
    private String serialNumber;

    @ApiModelProperty(value = "请求id")
    private String requestId;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "是否是委托实名 0 否   1 是")
    private Integer isTrust;

    @ApiModelProperty(value = "是否是二手车实名 0 否   1 是")
    private Integer isSecondHandCar;

    @ApiModelProperty(value = "订单信息dto")
    private RnrOrderDTO order;

    @ApiModelProperty(value = "实名信息dto")
    private MgRnrInfoDTO info;

    @ApiModelProperty(value = "实名公司信息dto")
    private MgRnrCompanyInfoDTO companyInfo;

    @ApiModelProperty(value = "实名卡信息")
    private List<MgRnrCardInfoDTO> cardList;

    @ApiModelProperty(value = "实名标签信息")
    private List<MgRnrTagDTO> rnrTagList;

    @ApiModelProperty(value = "实名联系人信息")
    private List<MgRnrLiaisonInfoDTO> rnrLiaisonList;

    @ApiModelProperty(value = "实名文件信息")
    private List<MgRnrFileDTO> rnrFileList;

    private Integer carNumber;

    public RnrRelationDTO() {
    }

    public RnrRelationDTO(RnrOrderDTO order, MgRnrInfoDTO info,
                          MgRnrCompanyInfoDTO companyInfo,
                          List<MgRnrCardInfoDTO> cardList,
                          List<MgRnrTagDTO> rnrTagList,
                          List<MgRnrLiaisonInfoDTO> rnrLiaisonList,
                          List<MgRnrFileDTO> rnrFileList) {
        this.order = order;
        this.info = info;
        this.companyInfo = companyInfo;
        this.cardList = cardList;
        this.rnrTagList = rnrTagList;
        this.rnrLiaisonList = rnrLiaisonList;
        this.rnrFileList = rnrFileList;
    }
}

