package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 实名工单操作日志(MgRnrOrderOperationLog)传输对象类
 *
 * @author yuy336
 * @since 2022-03-04 10:07:42
 */
@ApiModel(value = "实名工单操作日志", description = "实名工单操作日志")
@Data
public class RnrOrderOperationLogDTO extends BaseRnrMgPageDTO {

    private static final long serialVersionUID = -50160020144957830L;
    
    @ApiModelProperty(value = "业务主键")
    private String uuid;
    
    @ApiModelProperty(value = "工单uuid")
    private String orderId;
    
    @ApiModelProperty(value = "实名id")
    private String rnrId;
    
    @ApiModelProperty(value = "操作类型")
    private Integer optType;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "更新内容")
    private String updatedContent;
    
    @ApiModelProperty(value = "操作时间")
    private Date optTime;
    
    @ApiModelProperty(value = "更新码")
    private Long updatedCode;
}

