package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 实名标签，可用于对数据权限查询(MgRnrTag)传输对象类
 *
 * @author yuy336
 * @since 2022-01-26 13:38:48
 */
@ApiModel(value = "实名标签，可用于对数据权限查询", description = "实名标签，可用于对数据权限查询")
@Data
public class MgRnrTagDTO extends BaseRnrMgPageDTO {

    private static final long serialVersionUID = 854323668874658731L;
    
    @ApiModelProperty(value = "业务主键")
    private String uuid;
    
    @ApiModelProperty(value = "实名id")
    private String rnrId;
    
    @ApiModelProperty(value = "实名工单id")
    private String rnrOrderId;
    
    @ApiModelProperty(value = "标签名称")
    private String tagName;
    
    @ApiModelProperty(value = "标签值")
    private String tagValue;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "分表路由键")
    private Long routingKey;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;

    @ApiModelProperty(value = "业务类型：1 实名, 2 解绑, 3 换件,  4 信息变更,5 重绑")
    private Integer rnrBizzType;
}

