package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 实名业务公共配置(MgRnrCommonConfig)传输对象类
 *
 * @author yuy336
 * @since 2022-03-03 10:56:11
 */
@ApiModel(value = "实名业务公共配置", description = "实名业务公共配置")
@Data
public class MgRnrCommonConfigDTO extends BaseRnrMgDTO {

    private static final long serialVersionUID = -26898137451550837L;
    
    @ApiModelProperty(value = "配置键")
    private String configKey;
    
    @ApiModelProperty(value = "配置值")
    private String configValue;
    
    @ApiModelProperty(value = "全路径")
    private String configPath;
    
    @ApiModelProperty(value = "认证方式实例")
    private Long parentId;
    
    @ApiModelProperty(value = "父节点配置键")
    private String parentPath;
    
    @ApiModelProperty(value = "排序")
    private Integer configOrder;
    
    @ApiModelProperty(value = "描述")
    private String comments;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;
}

