package com.cusc.nirvana.user.rnr.mg.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;
import java.util.Date;

/**
 * 实名认证结果(MgRnrAuthenticationResult)传输对象类
 *
 * @author yuy336
 * @since 2022-05-19 17:35:28
 */
@ApiModel(value = "实名认证结果", description = "实名认证结果")
@Data
public class MgRnrAuthenticationResultDTO implements Serializable {

    private static final long serialVersionUID = -46720649570243410L;

    @ApiModelProperty(value = "数据库主键")
    private Long id;

    @ApiModelProperty(value = "业务主键")
    private String uuid;
    
    @ApiModelProperty(value = "业务类型：1 实名, 2 解绑, 3 换件,  4 信息变更,5 重绑")
    private Integer rnrBizzType;

    @ApiModelProperty(value = "主体类型: 1 本人 2 委托人")
    private Integer subjectType;
    
    @ApiModelProperty(value = "实名业务主键")
    private String rnrId;
    
    @ApiModelProperty(value = "实名工单id")
    private String orderId;
    
    @ApiModelProperty(value = "认证方式类型")
    private String authWayType;
    
    @ApiModelProperty(value = "实名认证结果")
    private String authResult;
    
    @ApiModelProperty(value = "实名认证结果描述")
    private String authResultMsg;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "分表路由键")
    private Long routingKey;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "创建人")
    private String creator;

    @ApiModelProperty(value = "操作人")
    private String operator;
}

