package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
public class LocalVerifyListRqDTO {
    @ApiModelProperty(value = "审核用户id")
    private String userId;
    @ApiModelProperty(value = "应用id")
    private String applicationId;
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "工单id")
    private String rnrOrderInfoId;
    @ApiModelProperty(value = "vin号")
    private String vin;
    @ApiModelProperty(value = "iccid号")
    private String iccid;
    @ApiModelProperty(value = "实名开始日期")
    private String rnrStartDate = DateUtil.getIntervalDateStr(new Date(), DateUtil.yyyy_MM_dd_HH_mm_ss, DateUtil.BEFORE, 30);
    @ApiModelProperty(value = "实名结束日期")
    private String rnrEndDate = DateUtil.toString(new Date(), DateUtil.yyyy_MM_dd_HH_mm_ss);
    @ApiModelProperty(value = "车主姓名")
    private String vinOwnerName;
    @ApiModelProperty(value = "车主电话")
    private String vinOwnerPhone;
    @ApiModelProperty(value = "业务类型")
    private String orderType;
    @ApiModelProperty(value = "车企名称")
    private String vinCompanyName;
    @ApiModelProperty(value = "经销商名称")
    private String orgName;
    @ApiModelProperty(value = "当前页码")
    private Integer currPage = 1;
    @ApiModelProperty(value = "页面显示行数")
    private Integer pageSize = 10;
}
