package com.cusc.nirvana.user.rnr.mg.constants;

/**
 * Description: 实名图片类型枚举
 * <br />
 * CreateDate 2021-10-28 12:49:12
 *
 * @author yuyi
 **/
public enum RnrImageTypeEnum {

    CERT_FRONT(1, "证件正面照"),
    CERT_BACK(2, "证件反面照"),
    HOLD_CERT_FRONT(3, "手持证件正面照"),
    ONLINE_PHOTO(4, "网文照/芯片照"),
    LIVE_PHOTO(5, "活体照"),
    ;

    private int code;
    private String name;

    RnrImageTypeEnum(int code, String name) {
        this.code = code;
        this.name = name;
    }

    public static RnrImageTypeEnum getEnumByCode(int code) {
        for (RnrImageTypeEnum sys : RnrImageTypeEnum.values()) {
            if (sys.getCode() == code) {
                return sys;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
