package com.cusc.nirvana.user.rnr.mg.constants;

/**
 * Description: 认证方式类型枚举
 * <br />
 * CreateDate 2022-02-14 15:31:33
 *
 * @author yuyi
 **/
public enum AuthWayTypeEnum {

    CERT_CHECK("CERT_CHECK", "身份信息核查"),
    ID_COMPARE("ID_COMPARE", "人证比对"),
    FACE_COMPARE("FACE_COMPARE", "人脸比对"),
    FMP("FMP", "活体后端校验"),
    OCR("OCR", "光符识别"),
    LIVENESS("LIVENESS", "活体检测"),
    LIVENESS_CODE("LIVENESS_CODE", "活体数字验证码"),
    ACTION_SEQ("ACTION_SEQ", "活体序列"),
    CARD_NUM_IOV("CARD_NUM_IOV", "车联网一证十卡");

    private String code;
    private String name;

    AuthWayTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static AuthWayTypeEnum getEnumByCode(String code) {
        for (AuthWayTypeEnum sys : AuthWayTypeEnum.values()) {
            if (sys.getCode().equals(code)) {
                return sys;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

}
