package com.cusc.nirvana.user.rnr.mg.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.*;

/**
 * 实名解绑DTO
 *
 * @author yuy336
 * @since 2022-02-10 18:28:52
 */
@ApiModel(value = "实名解绑DTO", description = "实名解绑DTO")
@Data
public class RnrUnbindDTO implements Serializable {

    private static final long serialVersionUID = -31644503457036551L;

    @ApiModelProperty(value = "VIN")
    private String vin;

    @ApiModelProperty(value = "ICCID")
    private String iccid;

    @ApiModelProperty(value = "姓名")
    private String fullName;

    @ApiModelProperty(value = "证件类型")
    private String certType;

    @ApiModelProperty(value = "证件号码")
    private String certNumber;

    @ApiModelProperty(value = "联系电话")
    private String phone;

    @ApiModelProperty(value = "解绑原因 1.报废 2.过户3.二手车交易9.其他")
    private Integer reason;

    @ApiModelProperty(value = "解绑说明")
    private String description;

    @ApiModelProperty(value = "交易证明")
    private String evidence;

    @ApiModelProperty(value = "是否手工界解绑")
    private boolean isManualUnbind;
}

