package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 实名操作日志，包含rnr_info_oplog(MgRnrOperationLog)传输对象类
 *
 * @author yuy336
 * @since 2022-03-04 15:07:28
 */
@ApiModel(value = "实名操作日志，包含rnr_info_oplog", description = "实名操作日志，包含rnr_info_oplog")
@Data
public class MgRnrOperationLogDTO extends BaseRnrMgPageDTO {

    private static final long serialVersionUID = -58334080147962616L;
    
    @ApiModelProperty(value = "业务主键")
    private String uuid;
    
    @ApiModelProperty(value = "业务数据主键")
    private String bizUuid;
    
    @ApiModelProperty(value = "操作描述")
    private String content;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "业务类型：1 info")
    private Integer bizType;
    
    @ApiModelProperty(value = "操作类型")
    private Integer optType;
    
    @ApiModelProperty(value = "具体操作")
    private Integer optSubType;
    
    @ApiModelProperty(value = "操作时间")
    private Date optTime;
    
    @ApiModelProperty(value = "理由（失败或解绑）")
    private Integer reason;
    
    @ApiModelProperty(value = "来源")
    private String source;
    
    @ApiModelProperty(value = "流水号")
    private String serialNumber;

    @ApiModelProperty(value = "是否是批量订单")
    private Integer isBatchOrder;
}

