package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 实名信息表(MgRnrInfo)传输对象类
 *
 * @author yuy336
 * @since 2022-02-10 18:28:52
 */
@ApiModel(value = "实名信息表", description = "实名信息表")
@Data
public class MgRnrInfoDTO extends BaseRnrMgPageDTO {

    private static final long serialVersionUID = -31644503457036551L;

    @ApiModelProperty(value = "业务主键")
    private String uuid;

    @ApiModelProperty(value = "自然人姓名")
//    @NotBlank(groups = SaveRelation.class, message = "自然人姓名不能为空")
    private String fullName;

    @ApiModelProperty(value = "证件类型")
//    @NotBlank(groups = SaveRelation.class, message = "证件类型不能为空")
    private String certType;

    @ApiModelProperty(value = "证件号")
//    @NotBlank(groups = SaveRelation.class, message = "证件号不能为空")
    private String certNumber;

    @ApiModelProperty(value = "证件地址")
//    @NotBlank(groups = SaveRelation.class, message = "证件地址不能为空")
    private String certAddress;

    @ApiModelProperty(value = "证件生效时间")
//    @NotNull(groups = SaveRelation.class, message = "证件生效时间不能为空")
    private Date effectiveDate;

    @ApiModelProperty(value = "证件失效时间")
//    @NotNull(groups = SaveRelation.class, message = "证件失效时间不能为空")
    private String expiredDate;

    @ApiModelProperty(value = "发证机关")
//    @NotBlank(groups = SaveRelation.class, message = "发证机关不能为空")
    private String issuingAuthority;

    @ApiModelProperty(value = "联系地址")
    private String contactAddress;

    @ApiModelProperty(value = "手机号")
//    @NotBlank(groups = SaveRelation.class, message = "手机号不能为空")
    private String phone;

    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "性别")
//    @NotNull(groups = SaveRelation.class, message = "性别不能为空")
    private Integer gender;

    @ApiModelProperty(value = "出生年月")
    private Date birthday;

    @ApiModelProperty(value = "民族")
    private String nation;

    @ApiModelProperty(value = "国家")
    private String country;

    @ApiModelProperty(value = "证件唯一编码")
    private String dnCode;

    @ApiModelProperty(value = "是否为企业 0 不是 1  是")
    //@NotNull(groups = SaveRelation.class, message = "是否为企业不能为空")
    private Integer isCompany;

    /**
     * 是否是委托实名 0 否   1 是
     */
    @ApiModelProperty(value = "是否是委托实名")
    private Integer isTrust;

    /**
     * 是否是二手车实名 0 否   1 是
     */
    @ApiModelProperty(value = "是否是二手车实名")
    private Integer isSecondHandCar;

    @ApiModelProperty(value = "企业uuid")
    private String rnrCompanyId;

    @ApiModelProperty(value = "实名状态 0 未实名 （认证中） 1 已实名  2 实名失败")
    private Integer rnrStatus;

    @ApiModelProperty(value = "用户id（ciam_user）")
    private String userId;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "组织id")
    private String orgId;

    @ApiModelProperty(value = "分表路由键")
    private Long routingKey;

    @ApiModelProperty(value = "最后一次操作人")
    private String operator;

	@ApiModelProperty(value = "业务主键集合")
    private List<String> uuidList;

	@ApiModelProperty(value = "公司名称")
	private String companyName;

    @ApiModelProperty(value = "业务类型：1 实名, 2 解绑, 3 换件,  4 信息变更,5 重绑")
    private Integer rnrBizzType;
}

