package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 实名卡信息(MgRnrCardInfo)传输对象类
 *
 * @author yuy336
 * @since 2022-03-04 11:06:36
 */
@ApiModel(value = "实名卡信息", description = "实名卡信息")
@Data
public class MgRnrCardInfoDTO extends BaseRnrMgPageDTO {

    private static final long serialVersionUID = -77640748451387414L;

    @ApiModelProperty(value = "业务主键")
    private String uuid;

    @ApiModelProperty(value = "实名业务主键")
    private String rnrId;

    @ApiModelProperty(value = "实名工单主键")
    private String orderId;

    @ApiModelProperty(value = "用户id（ciam_user）")
    private String userId;

    @ApiModelProperty(value = "老的业务id，换人之前的cardid")
    private String oldCardId;

    @ApiModelProperty(value = "卡号")
//    @NotBlank(groups = SaveRelation.class, message = "卡号不能为空")
    private String iccid;

    @ApiModelProperty(value = "物联网设备id")
//    @NotBlank(groups = SaveRelation.class, message = "物联网设备id不能为空")
    private String iotId;

    @ApiModelProperty(value = "实名状态 0 未实名  1 已实名 2 实名失败 3 已解绑")
//    @NotNull(groups = SaveRelation.class, message = "实名状态不能为空")
    private Integer rnrStatus;
    @ApiModelProperty(value = "通知状态，发送mq的状态。0 未发送 1已发送")
    private Integer noticeStatus;

    @ApiModelProperty(value = "T1上报状态。0 未上报 1已发送")
    private Integer t1UploadStatus;

    @ApiModelProperty(value = "业务类型：1 实名, 2 解绑, 3 换件,  4 信息变更,5 重绑")
    private Integer rnrBizzType;

    @ApiModelProperty(value = "业务类型：1 实名, 2 解绑, 3 换件,  4 信息变更,5 重绑")
    private List<Integer> bizTypeList;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "分表路由键")
    private Long routingKey;

    @ApiModelProperty(value = "语言版本")
    private Long lang;

    @ApiModelProperty(value = "备注信息")
    private Long comment;

    @ApiModelProperty(value = "最后一次操作人")
    private String operator;

    @ApiModelProperty(value = "iccid集合")
    private List<String> iccidList;

    @ApiModelProperty(value = "vin集合")
    private List<String> vinList;

    @ApiModelProperty(value = "实名工单主键集合")
    private List<String> rnrIdList;
}

