package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author hxin
 * @date 2022/5/17 16:10
 */
@ApiModel(value = "审核进度查询信息", description = "审核进度查询信息")
@Data
public class MgCheckProgressDTO extends BaseRnrMgPageDTO {

    @ApiModelProperty(value = "车辆vin号")
    private String iotId;

    @ApiModelProperty(value = "关联iccid")
    private String iccid;

    @ApiModelProperty(value = "业务类型")
    private String orderType;

    @ApiModelProperty(value = "审核进度")
    private String orderStatus;

    @ApiModelProperty(value = "审核人")
    private String checkUser;

    @ApiModelProperty(value = "提审日期 ")
    private String startCheckDate;

    @ApiModelProperty(value = "审核日期 ")
    private String endCheckDate;

    @ApiModelProperty(value = "组织id ")
    private String orgId;

    @ApiModelProperty(value = "车主/责任人")
    private String fullName;

    @ApiModelProperty(value = "车主/责任人手机")
    private String phone;

    @ApiModelProperty(value = "企业名称")
    private String companyName;

    @ApiModelProperty(value = "是否车企实名 0 否 1是")
    private Integer isVehicleCompany;

    @ApiModelProperty(value = "经销商名称")
    private String orgName;

    @ApiModelProperty(value = "提审开始日期")
    private String startCheckBegin;

    @ApiModelProperty(value = "提审结束日期")
    private String startCheckEnd;

    @ApiModelProperty(value = "审核开始日期 ")
    private String endCheckBegin;

    @ApiModelProperty(value = "审核结束日期 ")
    private String endCheckEnd;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "所有下级车企组织idList")
    private List<String> orgIdList;

}
