package com.cusc.nirvana.user.rnr.mg.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Description: 工单企业详情信息回显DTO
 **/
@Data
public class EnterpriseVerifyDetailDTO implements Serializable {
    private static final long serialVersionUID = 8325801116331488860L;

    @ApiModelProperty("请求ID")
    private String requestId;

    //---------------工单信息---------------------------------------------------------
    //工单信息，从列表页面带过去
    @ApiModelProperty(value = "工单详情")
    private RnrOrderDetail rnrOrderDetail = new RnrOrderDetail();

    @Data
    public static class RnrOrderDetail {
        @ApiModelProperty(value = "经销商名称")
        private String orgName;
        @ApiModelProperty(value = "车企名称")
        private String vinCompanyName;
        @ApiModelProperty(value = "业务类型")
        private String rnrBizzName;
        @ApiModelProperty(value = "实名日期")
        private String rnrDate;
    }

    //---------------企业信息---------------------------------------------------------
    @ApiModelProperty(value = "企业信息")
    private CompanyInfoDetail companyInfoDetail = new CompanyInfoDetail();

    @Data
    public static class CompanyInfoDetail {
        @ApiModelProperty("企业名称")
        private String companyName;

        @ApiModelProperty("企业性质")
        private String companyType;

        @ApiModelProperty("行业性质")
        private String industryType;

        @ApiModelProperty("企业证件类型")
        private String companyCertType;

        @ApiModelProperty("企业证件类型名称")
        private String companyCertTypeName;

        @ApiModelProperty("企业证件号码")
        private String companyCertNumber;

        @ApiModelProperty("证件地址")
        private String companyCertAddress;

        @ApiModelProperty("企业通讯地址")
        private String companyContactAddress;

        @ApiModelProperty("营业执照照片")
        private String licensePic;

        @ApiModelProperty("企业证件照片")
        private List<MgRnrFileDTO> companyLicenseFiles;

    }

    //---------------企业责任人信息---------------------------------------------------------
    @ApiModelProperty(value = "企业责任人信息")
    private CorporationInfoDetail corporationInfoDetail = new CorporationInfoDetail();

    @Data
    public static class CorporationInfoDetail {

        @ApiModelProperty(value = "责任人姓名")
        private String corporationName;

        @ApiModelProperty(value = "性别")
        private Integer corporationGender;

        @ApiModelProperty(value = "性别名称")
        private String corporationGenderName;

        @ApiModelProperty(value = "责任人证件类型")
        private String corporationCertType;

        @ApiModelProperty(value = "责任人证件号")
        private String corporationCertNumber;

        @ApiModelProperty(value = "责任人证件地址")
        private String corporationCertAddress;

        @ApiModelProperty(value = "责任人证件正面")
        private MgRnrFileDTO corporationCertFrontPic;

        @ApiModelProperty(value = "责任人证件反面")
        private MgRnrFileDTO corporationCertBackPic;

        @ApiModelProperty(value = "责任人证件有效期")
        private String corporationCertExpirationDate;

//        @ApiModelProperty(value = "责任人证件有效期")
//        @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
//        private Date corporationCertExpirationString;

        @ApiModelProperty(value = "责任人活体照片")
        private String corporationPhoto;

        @ApiModelProperty(value = "责任人通讯地址")
        private String corporationContactAddress;

        @ApiModelProperty(value = "责任人手机号码")
        private String corporationPhone;

        @ApiModelProperty(value = "企业实名认证授权书")
        private List<MgRnrFileDTO> authorizationLetterPic;

        @ApiModelProperty("合同集合")
        private List<String> fileSystemList;
    }

    //---------------活体认证图片信息---------------------------------------------------------
    @ApiModelProperty(value = "认证信息")
    private VerifyLivingMsg verifyLivingMsg = new VerifyLivingMsg();

    @Data
    public static class VerifyLivingMsg {
        @ApiModelProperty(value = "人脸图片")
        private List<MgRnrFileDTO> faceImages = new ArrayList<>();
        @ApiModelProperty(value = "活体认证视频")
        private MgRnrFileDTO livingVideo;
    }

    //---------------认证结果信息---------------------------------------------------------
    @ApiModelProperty(value = "认证结果")
    private List<AuthResult> authResultInfo;

    @Data
    public static class AuthResult {
        @ApiModelProperty(value = "认证动作")
        private String tpAction;
        @ApiModelProperty(value = "认证动作描述")
        private String tpActionName;
        @ApiModelProperty(value = "是否成功")
        private Boolean success;
        @ApiModelProperty(value = "结果描述")
        private String message;
    }

    @ApiModelProperty(value = "审核信息")
    private VerifyMsg verifyMsg = new VerifyMsg();

    @Data
    public static class VerifyMsg {
        @ApiModelProperty(value = "审核人员")
        private String reviewer;

        @ApiModelProperty(value = "审核日期")
        private String reviewDate;

        @ApiModelProperty(value = "审核意见")
        private List<String> verifyComments;

        @ApiModelProperty(value = "其他意见")
        private String otherComments;

        @ApiModelProperty(value = "工单状态")
        private Integer orderStatus;

    }


}
