package com.cusc.nirvana.user.rnr.mg.constants;

/**
 * Description: 实名业务响应码枚举
 * <br />
 * CreateDate 2022-03-01 14:26:26
 *
 * @author yuyi
 **/
public enum RnrResponseCode {

    NOT_FOUND_RNRINFO("10E000025", "查询不到当前车辆的实名认证信息，请确认填写信息是否正确"),

    GET_TOKEN_ERR("10E000028", "获取token配置信息失败"),
    TOKEN_EXPIRED("10E000029", "token已经过期"),
    URL_EXPIRED("10E000030", "链接已失效"),
    NOT_PERMISSION("10E000031", "无此操作权限"),

    SUCCESS("0", "成功"),
    INVALID_DATA("1", "数据校验不通过"),
    SYS_BUSY("2", "服务调用失败"),
    SERVICE_NOT_FOUND("3", "服务不存在"),
    TP_SYS_BUSY("4", "第三方服务调用失败"),
    JSON_FORMAT_ERROR("5", "参数格式错误"),
    REQUEST_TOO_LARGE("6", "请求数据不能超过5MB"),
    REQ_TOO_MANY_TIMES("7", "请求过于频繁，请稍后再试!"),

    BRAND_NULL("99E000001", "品牌不能为空"),
    ACCOUNT_NULL("99E000002", "请输入登陆账号"),
    REQ_BRAND_ALL_NULL("99E000003", "所有品牌不能为空"),

    SERIAL_NULL("99E000005", "流水号不能为空"),
    UNBIND_REASON_NULL("99E000006", "解绑原因不能为空"),
    NAME_NULL("99E000007", "姓名不能为空"),
    CERT_TYPE_NULL("99E000008", "证件类型不能为空"),
    CERT_NUM_NULL("99E000009", "证件号不能为空"),
    CERT_TYPE_INVALID("99E000010", "证件类型不正确"),
    CERT_NUM_INVALID("99E000011", "证件号码不正确"),
    USER_ADDR_INVALID("99E000012", "联系地址不正确"),
    USER_EMAIL_INVALID("99E000013", "联系邮箱不正确"),
    PHONE_NUM_NULL("99E000014", "手机号码不能为空"),
    NAME_INVALID("99E000015", "姓名不正确"),
    PASSWD_NULL("99E000016", "密码不能为空"),
    SERIAL_INVALID("99E000017", "流水号不正确"),
    BATCH_NULL("99E000018", "是否批量为空"),
    CODE_NUM_NULL("99E000390", "验证码不能为空"),
    CERT_TYPE_ERROR("99E000391", "证件类型错误"),

    USERNAME_NULL("99E000019", "用户名不能为空"),
    VIN_IMEI_NULL("99E000020", "VIN和IMEI不能同时为空"),
    IMSI_INVALID("99E000021", "IMSI不正确"),
    MSISDN_INVALID("99E000022", "MSISDN不正确"),
    IMEI_INVALID("99E000023", "IMEI不正确"),
    DEVICEID_INVALID("99E000024", "DEVICEID不正确"),
    REQ_PARAM_INVALID("99E000025", "请求参数不合法"),
    REQ_PARAM_NULL("99E000026", "请求参数不能为空"),
    REQ_BRAND_NOT_SINGLE("99E000027", "请求数据品牌参数不唯一"),
    REQ_MODEL_NOT_SINGLE("99E000028", "请求数据车型参数不唯一"),
    ICCID_NULL("99E000029", "ICCID不能为空"),
    GENDER_NULL("99E000030", "性别不能为空"),
    GENDER_INVALID("99E000031", "性别不正确"),
    PIC1_NULL("99E000032", "证件正面照片不能为空"),
    PIC2_NULL("99E000033", "证件背面照片不能为空"),
    VIN_ICCID_PHONE_NULL("99E000034", "VIN,ICCID,手机号不能同时为空"),
    NEW_ICCID_NULL("99E000035", "新ICCID不能为空"),
    OLD_ICCID_NULL("99E000036", "旧ICCID不能为空"),

    PHONE_LENGTH_ERR("99E000038", "手机号码长度不正确"),
    VIN_NULL("99E000039", "VIN不能为空"),

    COM_NAME_NULL("99E000042", "企业名称不能为空"),
    COM_ADDR_NULL("99E000043", "企业地址不能为空"),
    COM_NUM_NULL("99E000044", "企业证件号不能为空"),
    COM_NAME_INVALID("99E000045", "企业名称不正确"),
    COM_ADDR_INVALID("99E000046", "企业地址不正确"),
    COM_NUM_INVALID("99E000047", "企业证件号不正确"),
    COM_CERT_PIC_NULL("99E000048", "单位证件扫描件不能为空"),
    COM_AUTH_PIC_NULL("99E000049", "单位委托书扫描件不能为空"),

    COM_INDUSTRY_TYPE_NULL("99E000051", "行业类型不能为空"),
    COM_TYPE_NULL("99E000052", "企业类型不能为空"),
    COM_INDUSTRY_TYPE_INVALID("99E000053", "行业类型不正确"),
    COM_TYPE_INVALID("99E000054", "企业类型不正确"),
    VIN_ICCID_BIND_NULL("99E000055", "车卡绑定关系不存在"),
    VIN_LENGTH_ERR("99E000056", "VIN长度错误"),
    DATA_NOTEXIST("99E000057", "数据不存在"),
    BASE_IMG_NULL("99E000058", "证件照片不能为空"),
    FACE_IMG_NULL("99E000059", "真人照片不能为空"),

    WAIT_CHECK("99E000061", "等待审核中，请勿重复提交！"),

    BIND_OTHER_USER("99E000066", "已绑定其他用户"),
    DATA_TOO_LONG("99E000067", "数据过长"),
    SIM_NUM_OVER5("99E000068", "绑定的SIM卡超过五张"),
    UPD_PHONE_OVER_5_SIM("99E000069", "合户后超过五张卡，无法更新手机号"),

    SIM_NUM_OVER_NEW("99E000068", ""),
    UPD_PHONE_OVER_SIM_NEW("99E000069", ""),

    // generic portal
    HAVE_BINDED("99E000070", "该VIN已经绑定，是否覆盖？"),
    PIC_NOT_ACCESS("99E000071", "照片识别未超过阈值！"),

    NOT_RNR("99E000073", "该用户尚未实名认证"),

    VIN_USER_BIND_NULL("99E000076", "人车绑定关系不存在"),
    PHONE_EMAIL_NULL("99E000077", "手机号和邮箱不能同时为空"),

    INTERVAL_NULL("99E000078", "扫描间隔不能为空"),
    OPENTIME_NULL("99E000079", "上班时间不能为空"),
    CLOSETIME_NULL("99E000080", "下班时间不能为空"),
    CLOSETIME_BEFORE_OPENTITME("99E000081", "下班时间不能早于上班时间"),
    TIMEOUT_NULL("99E000082", "超时时间不能为空"),

    // daimler
    MOBILENO_NOT_EXIST("99E000083", "该手机号不存在"),
    ERR_USERNAME_PASSWD("99E000084", "用户名或密码错误"),
    SERVICE_NULL("99E000085", "服务不能为空"),
    TMESTAMP_NULL("99E000086", "请求时间不能为空"),

    ICCID_INVALID("99E000087", "请输入正确的ICCID"),
    AOP_FALL("99E000088", "AOP调用失败"),
    USER_NON_EXISTENT("99E000089", "用户不存在"),
    TO_EXAMINE("99E000090", "<p>已转入人工审核！</p><p>请关注之后短信通知。</p>"),

    GZT_FALL("99E000092", "国政通调用失败"),

    OCR_FALL("99E000093", "图片识别调用失败"),

    VIN_ICCID_NULL("99E000094", "VIN和ICCID不能同时为空"),
    VIN_ICCID_LENGTH_ERR("99E000095", "VIN或ICCID长度错误"),

    VEHICLE_CARD_NULL("99E000102", "没有输入车卡请求数据"),

    VIN_PHONENUM_NULL("99E000104", "VIN和手机号不能同时为空"),

    BRAND_ID_NOT_EXIST("99E000106", "车企编码不存在"),
    ICCID_BIND_OTHER_VIN("99E000107", "ICCID已绑定其他车辆"),

    MSISDN_NULL("99E000118", "msisdn不能为空"),
    NOT_AMSP("99E000119", "非后装，请走其他查询接口"),
    REBIND_ERROR_CUSTYPE_WRONG("99E000120", "用户类型不正确，请更换接口"),
    UNBIND_FAIL("99E000121", "解绑失败"),
    VIN_BIND_OTHER_ICCID("99E000122", "VIN已绑定其他SIM卡"),
    NO_UNBIND_DATA("99E000123", "未找到需解绑的数据"),
    NO_REBIND_DATA("99E000124", "未找到需重绑的数据"),

    REPEAT_SUBMIT("99E000131", "请勿重复提交"),
    THIRDPARTH_INFO_NULL("99E000132", "无第三方服务配置信息"),

    DAIVB_VIN_NOTEXIST("99E000133", "VIN码无法通过验证，请重新输入。如有疑问请提交DOCTOR工单或拨打热线4008403500"),

    DATA_BIND_OTHER_BRAND("99E000135", "车卡数据已绑定其他品牌"),

    //集团活体照片
    LIVE_PIC1_NULL("99E000136", "第一张活体照片不能为空"),
    LIVE_PIC2_NULL("99E000137", "第二张活体照片不能为空"),

    FACE_PIC_OVER_SIZE("99E000138", "身份证正面照照片不能超过500K"),
    BACK_PIC_OVER_SIZE("99E000139", "身份证反面照照片不能超过500K"),
    LIVE_PIC1_OVER_SIZE("99E000140", "第一张生活照照片不能超过32K"),
    LIVE_PIC2_OVER_SIZE("99E000141", "第二张生活照照片不能超过32K"),

    // H5补录专用
    H5_REGISTER_TYPE_NULL("99E000150", "认证类型不能为空"),
    H5_SEARCH_TEXT_NULL("99E000151", "查询条件不能为空"),
    H5_SEARCH_TEXT_INVALID("99E000152", "查询条件不合法"),
    H5_DATA_INVALID("99E000153", "数据结果不合法"),
    H5_VEHICLES_NULL("99E000154", "车辆数据不能为空"),
    H5_ONLY_EXIST_PERSONAL_DATA("99E000155", "只存在个人车辆"),
    H5_ONLY_EXIST_ENTERPRISE_DATA("99E000156", "只存在企业车辆"),
    H5_EXIST_MULTIPLE_PERSONAL("99E000157", "存在多个个人信息"),
    H5_EXIST_MULTIPLE_ENTERPRISE("99E000158", "存在多个企业信息"),
    H5_NONE_DATA("99E000159", "无此用户"),
    H5_ECC_CIPHER_NULL("99E000160", "ECC密文不能为空"),
    H5_DECODE_DATA_TYPE_NULL("99E000161", "解密数据类型不能为空"),
    H5_DECODE_DATA_TYPE_INVALID("99E000162", "解密数据类型不合法"),
    H5_FIRM_BIND_ID_NULL("99E000163", "企业绑定记录id不能为空"),
    H5_TENGXUN_LIVE_CHECK("99E000164", "活体检测成功不要重复提交"),
    H5_TENGXUN_LIVE_CHECK_WAIT("99E000165", "腾讯活体检测认证中，不要重复提交"),
    H5_TENGXUN_LIVE_CHECK_FAIL("99E000166", "腾讯活体检测失败！"),
    H5_TENGXUN_LIVE_RESULT_ERROR("99E000167", "腾讯活体检结果获取失败！"),

    //H5活体检测 - 修改手机号
    ORIGINAL_MOBILE_NULL("99E000392", "旧手机号码不能为空"),
    ORIGINAL_MOBILE_LENGTH_ERR("99E000393", "旧手机号码长度不正确"),
    NEW_MOBILE_NULL("99E000394", "新手机号码不能为空"),
    NEW_MOBILE_LENGTH_ERR("99E000395", "新手机号码长度不正确"),
    VERIFY_CODE_NULL("99E000396", "验证码不能为空"),
    TENGXUN_LIVE_CHECK_FAIL("99E000397", "腾讯活体检测失败"),
    TENGXUN_LIVE_COME_SIGN_FAIL("99E000398", "腾讯活体检测回调签名异常"),
    TENGXUN_LIVE_COME_ORDERNO_FAIL("99E000399", "腾讯活体检测回调订单号异常"),
    TENGXUN_LIVE_SIGN_ERR("99E000399", "腾讯活体检测sign已失效"),

    TENGXUN_LIVE_TOKEN_FAIL("99E000400", "活体检测TOKEN获取失败"),
    TENGXUN_LIVE_TICKET_FAIL("99E000401", "活体检测TICKET获取失败"),
    TENGXUN_LIVE_TICKET_NULL("99E000402", "活体检测TICKET获取值为空"),
    TENGXUN_LIVE_TICKET_CONFIG_USERID_NULL("99E000403", "活体检测TICKET参数userId配置为空"),
    TENGXUN_LIVE_TICKET_CONFIG_URL_NULL("99E000404", "活体检测H5LOGIN参数配置为空回调URL为空"),
    TENGXUN_LIVE_CHECK_RECORD_NULL("99E000405", "活体检测记录为空"),
    /**
     * 活体API
     */
    LIVE_API_P_LIVE_VEDIO_NULL("99E000501", "活体视频为空!"),
    LIVE_API_P_LIVE_DATA_NULL("99E000502", "活体验证数据为空!"),
    LIVE_API_P_LIVE_DATA_OVER_STANDARD("99E000503", "活体视频大小超过2M!"),
    LIVE_API_P_LIVE_VIDEO_PHOTO_ERROR("99E000504", "活体视频检测不到有效照片!"),
    LIVE_API_P_LIVE_VIDEO_ERROR("99E000505", "提交活体视频有问题!"),
    LIVE_API_P_LIVE_TYPE_NULL("99E000506", "活体检测类型为空!"),
    LIVE_API_P_LIVE_NUMBER_ERROE("99E000507", "活体唇语数字获取失败!"),
    LIVE_API_P_LIVE_RES_ERROR("99E000508", "活体检测结果异常!"),
    LIVE_API_P_LIVE_TOO_MANY("99E000509", "实名数据已超过200条"),
    SDK_LIVE_API_P_ORDER_NO_NULL("99E000510","sdk活体检测订单号为空!"),
    SDK_LIVE_API_P_RESULT_ERROR("99E000511", "腾讯SDK活体检测结果获取失败！"),
    SDK_LIVE_API_P_PHOTO_RESULT_ERROR("99E000512", "腾讯SDK活体检测照片结果获取失败！"),
    SDK_LIVE_API_P_PHOTO_RESULT_NOT_ALL("99E000513","腾讯SDK活体检测照片结果少于两张！"),
    SDK_LIVE_API_P_TICKET_FAIL("99E000514", "sdk活体检测TICKET获取失败"),
    SDK_LIVE_API_P_SDK_LIVE_TICKET_CONFIG_USERID_NULL("99E000515", "sdk活体检测TICKET参数userId配置为空"),
    SDK_LIVE_API_P_SDK_LIVE_FAIL("99E000516", "活体检测失败！"),
    CERTIFICATE_PIC_OVER_SIZE("99E000517", "二手车交易照片不能超过500k!"),
    VIN_PIC_OVER_SIZE("99E000518", "二手车车架号照片不能超过500k!"),

    TEMPLATE_NULL("99E000300", "模版不能为空"),
    CAPTCHA_NOT_EXIST("99E000301", "验证码错误"),
    CAPTCHA_OVERDUE("99E000302", "验证码已过期"),
    BIND_ERROR("99E000303", "绑定失败"),
    CERT_CHECK_FEQ("99E000304", "一条工单6小时之内只能调用一次身份认证"),
    FACE_COMPARE_FEQ("99E000305", "一条工单6小时之内只能调用一次AOP人脸比对"),
    CAPTCHA_NULL("99E000306", "验证码不能为空"),
    IMG_FORMAT_ERR("99E000307", "照片格式不正确"),
    WAIT_MANUAL_CHECK("99E000308", "人工审核中，请耐心等待"),
    NO_TEMPLATE("99E000309", "找不到模板"),
    SMS_FEQ("99E000310", "发送短信太频繁"),
    CLAIM_FAIL("99E000311", "工单认领失败"),
    ALLOCATE_FAIL("99E000312", "工单分配失败"),
    EXAMINE_FAIL("99E000313", "工单审核失败"),
    SEND_SMS_FALL("99E000314", "发送短信失败"),
    SEND_SMS_BFCPCODE_NULL("99E000414", "发送短信CPCODE为空"),
    SEND_SMS_CAPTCHA_NULL("99E000415", "发送短信验证码为空"),
    SEND_SMS_BFKEY_NULL("99E000416", "发送短信CPKEY为空"),
    HAD_BINDED("99E000315", "该VIN已经绑定"),
    CANNOT_ALLOCATED("99E000316", "工单无法分配"),
    ORDER_NOT_EXIST("99E000317", "工单不存在"),
    GZT_AUTHC_FALL("99E000318", "国政通认证失败"),
    RETRY_NOTIFY_ERROR("99E000319", "第三方通知重发失败"),
    ORDER_NOT_CHECK("99E000320", "工单尚未审核"),
    ORDER_NOT_LATEST("99E000321", "此车已存在其他工单，无法重发"),
    GZT_SUCCESS_NO_PIC("99E000322", "国政通返回一致，未返回照片"),
    TIME_NOT_NULL("99E000323", "时间不能为空"),
    TIME_INTERVAL_TOO_LARGE("99E000324", "时间间隔太大，需小于30天"),
    FULL_REPORT_NOT_EXIST("99E000325", "全量报表不存在，请先生成再下载"),
    WAIT_FOR_CREATE("99E000326", "报表已生成，请直接下载或稍候再试"),
    QUERY_TOTAL_ERROR("99E000327", " 请根据手机号或证件类型和证件号进行查询"),
    BASE_IMG_PIC_NULL("99E000328", "国政通照和证件正反照不能同时为空"),
    FACE_IMG_PIC_NULL("99E000329", "现场拍照和手持证件照不能同时为空"),
    NONE_REPRODUCE_ORDER("99E000330", "未找到需重新生成的工单或工单已存在"),
    DELETE_NOT_BIND_DATA_ERROR("99E000331", "删除未申请数据异常"),
    CANNOT_CHANGETBOX_NOT_RNR("99E000332", "该车未完成实名认证，不能进行SIM卡更换，请先完成实名认证！"),
    SYS_CODE_NULL("99E000333", "系统编码不能为空"),
    FMP_FEQ("99E000334", "一条工单6小时之内只能调用一次活体后端校验"),
    ID_CMPR_FEQ("99E000335", "一条工单6小时之内只能调用一次人证比对"),
    OPER_TYPE("99E000336", "非法的操作类型"),
    VENUS_UUID_NULL("99E000337", "uuid不能为空"),
    RNR_FAIL_NULL("99E000338", "审核失败原因不能为空"),
    RNR_AUDI_TYPE("99E000338", "非法的认证类型"),
    HAD_BINDED_ICCID("99E000339", "该ICCID已经绑定"),
    /***平台实名义证失败字典**/
    VENUS_0340("99E000340", "实名规则设置不正确"),
    VENUS_0341("99E000341", "vin号不存在"),
    VENUS_0342("99E000342", "vin或iccid不正确"),
    VENUS_0343("99E000343", "vin号和iccid不能同时为空"),
    VENUS_0344("99E000344", "车辆已经存在绑定关系"),
    VENUS_0345("99E000345", "个人客户绑定车辆数量超过限制(5辆)"),
    VENUS_0346("99E000346", "错误请求"),
    VENUS_0347("99E000347", "Vin不能为空"),
    VENUS_0348("99E000348", "iccid不能为空"),
    VENUS_0349("99E000349", "证件照正面照不能为空"),
    VENUS_0350("99E000350", "证件照国徽照不能为空"),
    VENUS_0351("99E000351", "个人手持证件照片不能为空"),
    VENUS_0352("99E000352", "姓名不能为空"),
    VENUS_0353("99E000353", "性别不合法"),
    VENUS_0354("99E000354", "证件号码不能为空"),
    VENUS_0355("99E000355", "证件类型不合法"),
    VENUS_0356("99E000356", "身份证号码不合法"),
    VENUS_0357("99E000357", "证件类型不能为空"),
    VENUS_0358("99E000358", "手机号不能为空"),
    VENUS_0359("99E000359", "手机号长度不正确"),
    VENUS_0360("99E000360", "车辆不属于B客户"),
    VENUS_0361("99E000361", "正在实名认证中"),
    VENUS_0380("99E000380", "企业营业执照不能为空"),
    VENUS_0381("99E000381", "授权书不能为空"),
    VENUS_0382("99E000382", "企业名称不能为空"),
    VENUS_0383("99E000383", "企业营业执照号码不能为空"),
    VENUS_0384("99E000384", "企业类型不能为空"),
    VENUS_0385("99E000385", "行业类型不能为空"),
    VENUS_0386("99E000386", "ICCID在通信中心不存在"),
    VENUS_V0370("V0370", "请求流水号重复"),
    //##################personbind start#########################
    VENUS_P_V0001("PV0001", "错误请求"),
    VENUS_P_V0252("PV0252", "车辆信息不存在"),
    VENUS_P_V0253("PV0253", "不存在车卡绑定关系"),
    VENUS_P_V0409("PV0409", "vin号和iccid不能同时为空"),
    VENUS_P_V0294("PV0294", "车辆已经存在绑定关系"),
    VENUS_P_V0297("PV0297", "个人客户绑定车辆数量超过限制5辆"),
    VENUS_P_V0410("PV0410", "实名规则设置不正确"),
    VENUS_P_V0448("PV0448", "不符合实名规则"),
    VENUS_P_V0385("PV0385", "Vin不能为空"),
    VENUS_P_V0411("PV0411", "iccid不能为空"),
    VENUS_P_V0383("PV0383", "证件照正面照不能为空"),
    VENUS_P_V0384("PV0384", "证件照国徽照不能为空"),
    VENUS_P_V0386("PV0386", "个人手持证件照片不能为空"),
    VENUS_P_V0378("PV0378", "姓名不能为空"),
    VENUS_P_V0390("PV0390", "性别不合法"),
    VENUS_P_V0380("PV0380", "证件号码不能为空"),
    VENUS_P_V0381("PV0381", "证件类型不合法"),
    VENUS_P_V0382("PV0382", "身份证号码不合法"),
    VENUS_P_V0379("PV0379", "证件类型不能为空"),
    VENUS_P_V0426("PV0426", "手机号不能为空"),
    VENUS_P_V0427("PV0427", "手机号长度不正确"),
    VENUS_P_V0298("PV0298", "车辆不属于B客户"),
    VENUS_P_V0192("PV0192", "正在实名认证中"),
    VENUS_P_V0396("PV0396", "证件照人面照超过限制大小(2M)"),
    VENUS_P_V0397("PV0397", "证件照国徽照超过限制大小(2M)"),
    VENUS_P_V0398("PV0398", "个人手持证件照片超过限制大小(2M)"),
    VENUS_P_V0408("PV0408", "iccid没有找到绑定的车辆"),
    VENUS_P_V0194("PV0194", "客户信息不正确"),
    VENUS_P_V0337("PV0337", "AppKey 无效或不存在"),
    VENUS_P_V0338("PV0338", "时间戳过时"),
    VENUS_P_V0339("PV0339", "时间戳不合法"),
    VENUS_P_V0370("PV0370", "X-V-Request-Id重复"),
    VENUS_P_V0342("PV0342", "SignatureNonce为空"),
    VENUS_P_V0345("PV0345", "签名无效。请确认签名计算字符及方法是否正确"),
    VENUS_P_V0350("PV0350", "未授权"),
    VENUS_P_V0347("PV0347", "未找到该api,该api地址不存在或者该服务能力下不存在此api地址"),
    VENUS_P_V0344("PV0344", "调用接口必填的参数未设置或参数位置不符或参数类型不符"),
    VENUS_P_V0349("PV0349", "该IP不在IP白名单中"),
    VENUS_P_V0351("PV0351", "该短路由不存在"),
    VENUS_P_V0082("PV0082", "服务异常"),
    //######################personbind end############################
    //##################companybind start#########################
    VENUS_C_V0001("CV0001", "错误请求"),
    VENUS_C_V0248("CV0248", "VIN号不能为空"),
    VENUS_C_V0383("CV0383", "证件照人面照不能为空"),
    VENUS_C_V0384("CV0384", "证件照国徽照不能为空"),
    VENUS_C_V0386("CV0386", "手持证件照不能为空"),
    VENUS_C_V0387("CV0387", "企业营业执照不能为空"),
    VENUS_C_V0388("CV0388", "授权书不能为空"),
    VENUS_C_V0378("CV0378", "责任人姓名不能为空"),
    VENUS_C_V0390("CV0390", "责任人性别不合法"),
    VENUS_C_V0380("CV0380", "责任人证件号码不能为空"),
    VENUS_C_V0381("CV0381", "责任人证件类型不合法"),
    VENUS_C_V0382("CV0382", "责任人证件号码不合法"),
    VENUS_C_V0379("CV0379", "责任人证件类型不能为空"),
    VENUS_C_V0391("CV0391", "企业名称不能为空"),
    VENUS_C_V0389("CV0389", "企业营业执照号码不能为空"),
    VENUS_C_V0392("CV0392", "企业类型不能为空"),
    VENUS_C_V0394("CV0394", "行业类型不能为空"),
    VENUS_C_V0426("CV0426", "手机号码不能为空"),
    VENUS_C_V0427("CV0427", "手机号码长度错误"),
    VENUS_C_V0396("CV0396", "证件照人面照超过限制大小(2M)"),
    VENUS_C_V0397("CV0397", "证件照国徽照超过限制大小(2M)"),
    VENUS_C_V0398("CV0398", "个人手持证件照片超过限制大小(2M)"),
    VENUS_C_V0399("CV0399", "企业营业执照照片超过限制大小(2M)"),
    VENUS_C_V0400("CV0400", "企业授权书照片超过限制大小(2M)"),
    VENUS_C_V0337("CV0337", "AppKey 无效或不存在"),
    VENUS_C_V0338("CV0338", "时间戳过时"),
    VENUS_C_V0339("CV0339", "时间戳不合法"),
    VENUS_C_V0370("CV0370", "X-V-Request-Id重复"),
    VENUS_C_V0342("CV0342", "SignatureNonce为空"),
    VENUS_C_V0345("CV0345", "签名无效。请确认签名计算字符及方法是否正确"),
    VENUS_C_V0350("CV0350", "未授权"),
    VENUS_C_V0347("CV0347", "未找到该api,该api地址不存在或者该服务能力下不存在此api地址"),
    VENUS_C_V0344("CV0344", "调用接口必填的参数未设置或参数位置不符或参数类型不符"),
    VENUS_C_V0349("CV0349", "该IP不在IP白名单中"),
    VENUS_C_V0351("CV0351", "该短路由不存在"),
    VENUS_C_V0082("CV0082", "服务异常"),
    //######################personbind end############################
    /* h5 ERROR CODE */
    USER_LOGIN_NULL("LOGIN_ERROR_01", "请输入用户名或手机号或邮箱"),
    USER_PWD_ERR("USER_PWD_ERR", "用户密码不正确"),
    USER_PWD_WEAK_TIP("USER_PWD_WEAK_TIP", "根据网络安全要求，系统检测到您输入的密码为弱密码，请点击忘记密码进行修改"),
    USER_PWD_WEAK("USER_PWD_WEAK", "用户密码为弱密码"),
    USER_LOGIN_FAIL("LOGIN_ERROR_02", "请输入正确的用户名或手机号或邮箱或密码"),
    USER_PICCAPTCHA_FAIL("LOGIN_ERROR_03", "请输入正确的验证码"),
    USER_VIN_LOGIN_FAIL("LOGIN_ERROR_03", "请输入正确的VIN或密码"),
    USER_REGISTER_PHONE_ERROR("USER_REGISTER_ERROR_01", "该手机号已注册"),
    USER_REGISTER_USERNAME_ERROR("USER_REGISTER_ERROR_02", "该用户名已注册"),
    USER_REGISTER_EMAIL_ERROR("USER_REGISTER_ERROR_03", "该邮箱已注册"),
    USER_REGISTER_FAIL("USER_REGISTER_FAIL", "用户注册失败"),
    USER_RESET_USERPWD_ERROR("USER_RESET_USERPWD_01", "手机号不存在"),
    USER_RESET_USERPWD_FAIL("USER_RESET_USERPWD_02", "修改密码失败"),
    USER_GET_PICCODE_ERROR("USER_GET_PICCODE_ERROR", "获取图片验证码失败"),
    USER_MERGE_OVER_5_SIM("USER_MERGE_OVER_5_SIM", "合户后超过五张卡，无法更新手机号"),
    USER_UPDATE_ERROR("USER_UPDATE_ERROR", "更新用户失败"),
    VIN_LACK_OF_SIM("VIN_LACK_OF_SIM", "该VIN缺少SIM卡，请添加后再进行实名认证"),

    // benz ipad
    BENZ_ADD_USER_ERROR("BENZ_ADD_USER_ERROR", "benz ipad用户添加失败"),
    BENZ_IPAD_ROLE_ERROR("BENZ_IPAD_ROLE_ERROR", "请配置benz ipad角色的数据字典"),
    BENZ_IPAD_ORG_ERROR("BENZ_IPAD_ORGAZIATION_ERROR", "请配置benz ipad所属组织的数据字典"),
    RNR_SUCCEED("RNR_SUCCEED", "此车已完成实名认证"),
    VENUS_CALL_FAIL("99E000V99", "调用微平台服务失败"),
    VENUS_CALL_ERROR("99E000388", "实名回调编码错误"),
    VENUS_CALL_CODE("99E000387", "实名回调编码不能为空"),
    INDENTIFY_CODE_NULL("99E000019", "实名状态码为空"),
    VENUS_CALL_CUST_CODE("99E000389", "B客户Id不能为空"),
    IDENTIFY_TYPE_NULL("99E000340", "实名类型为空"),
    IDENTIFY_TYPE_ERROR("99E000343", "实名类型编码错误"),
    CUST_ID_CHANGE_ERROR("99E000341", "B客户Id转换异常"),
    ORDER_REPEAT("99E000342", "工单重复"),
    SMS_SEND_MAX_COUNT("99E000342", "发送短信已到达当日最大次数"),
    PHONE_NUM_ERROR("99E000343", "手机号格式错误"),
    CERTIFICATE_PIC_NULL("99E000344", "二手车交易证明不能为空"),
    VIN_PIC_NULL("99E000345", "车架号照片不能为空"),

    H5_TOKEN_NULL("E101000001", "token为空,请先登录"),
    H5_TOKEN_NOT_EXIST("E10000002", "token不存在，请登录"),
    H5_TOKEN_EXPRIED("E10000003", "token无效或已过期，请重新登录"),
    H5_TOKEN_PHONE_ERROR("E10000004", "手机号的token信息为空，请登录"),
    JASPER_ERROR("E10000005","jasper调用异常"),
    JASPER_ICCID_STATUS_NULL("E10000006","jasper卡状态信息为空");

    /**
     * 响应码
     */
    private String code;

    /**
     * 响应描述
     */
    private String description;

    RnrResponseCode(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static RnrResponseCode getResponseByCode(String code) {
        for (RnrResponseCode resCode : values()) {
            if (resCode.code.equals(code)) {
                return resCode;
            }
        }
        return null;
    }
}
