package com.cusc.nirvana.user.rnr.mg.constants;

import java.util.Arrays;

/**
 * Description: 实名订单类型
 * <br />
 * CreateDate 2022-03-03 10:08:34
 *
 * @author yuyi
 **/
public enum RnrOrderType {

    NEW_VEHICLE(1, "自然人新车实名认证", 1),
    SEC_VEHICLE(2, "自然人二手车实名认证", 1),
    COMPANY_NEW_VEHICLE(3, "企业新车实名认证", 1),
    CARMAKER_NEW_VEHICLE(4, "车企新车实名认证", 1),
    COMPANY_CORPORATION_CHANGE(5, "企业责任人变更", 4),
    UNBIND(6, "车主解绑", 2),
    SEC_UNBIND(7, "二手车主解绑", 2),
    COMPANY_CORPORATION_UNBIND(8, "车企实名解绑", 2),
    TBOX_CHANGE(9, "设备更换", 3),
    ONE_CAR_MORE_CARD_BIND(10, "一车多卡绑定", 1),
    REBINDING(11, "重新绑定", 1),
    ENTERPRISEUNBIND(12, "企业解绑", 2);

    private Integer type;
    private String comment;
    private Integer rnrBizzType;

    RnrOrderType(Integer type, String comment, Integer rnrBizzType) {
        this.type = type;
        this.comment = comment;
        this.rnrBizzType = rnrBizzType;
    }

    public static RnrOrderType getTypeByCode(int code){
        return Arrays.stream(RnrOrderType.values())
                .filter(type -> type.getCode() == code)
                .findFirst()
                .orElseGet(null);
    }

    public static RnrOrderType getDescription(Integer key) {
        for (RnrOrderType type : values()) {
            if (type.type.equals(key)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return type;
    }

    public String getComment() {
        return comment;
    }
}
