package com.cusc.nirvana.user.rnr.mg.constants;

/**
 * Description: 联系人类型
 * <br />
 * CreateDate 2022-03-03 10:08:34
 *
 * @author yuyi
 **/
public enum RnrLiaisonType {
    CONSIGNEE(1, "被委托人"),
    OPERATOR(2, "经办人"),
    EMERGENCY_CONTACT(3, "紧急联系人")
    ;

    private Integer type;
    private String comment;

    RnrLiaisonType(Integer type, String comment) {
        this.type = type;
        this.comment = comment;
    }

    public static RnrLiaisonType getDescription(Integer key) {
        for (RnrLiaisonType type : values()) {
            if (type.type.equals(key)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return type;
    }

    public String getComment() {
        return comment;
    }
}
