package com.cusc.nirvana.user.rnr.mg.constants;

import org.apache.commons.lang3.StringUtils;

/**
 * 行业类型
 */
public enum IndustryTypeEnum {
    blmy(0, "农、林、牧、渔业"),
    cky(1, "采矿业"),
    zzy(2, "制造业"),
    dlrlrqjsschgyy(3, "电力、热力、燃气及水生产和供应业"),
    jzy(4, "建筑业"),
    pfhlsy(5, "批发和零售业"),
    jtyscchyzy(6, "交通运输、仓储和邮政业"),
    zshcyy(7, "住宿和餐饮业"),
    xxcsrjhxxjsfwy(8, "信息传输、软件和信息技术服务业"),
    jry(9, "金融业"),
    fdcy(10, "房地产业"),
    zlhswfwy(11, "租赁和商务服务业"),
    kxyjhjsfwy(12, "科学研究和技术服务业"),
    sl_hjhggssgly(13, "水利、环境和公共设施管理业"),
    jmfw_xlhqtfwy(14, "居民服务、修理和其他服务业"),
    jy(15, "教育"),
    wshshgz(16, "卫生和社会工作"),
    wh_tyhyly(17, "文化、体育和娱乐业"),
    gggl_shbzhshzz(18, "公共管理、社会保障和社会组织"),
    gjzz(19, "国际组织"),
    qt(20, "其他"),

    ;

    private int code;
    private String value;

    IndustryTypeEnum(int code, String value) {
        this.code = code;
        this.value = value;
    }

    public static IndustryTypeEnum getEnumByCode(int code) {
        for (IndustryTypeEnum item : IndustryTypeEnum.values()) {
            if (item.getCode() == code) {
                return item;
            }
        }
        return null;
    }

    public static IndustryTypeEnum getEnumByCode(String codeStr) {
        if (StringUtils.isBlank(codeStr)) {
            return null;
        }
        for (IndustryTypeEnum item : IndustryTypeEnum.values()) {
            if (item.getCode() == Integer.parseInt(codeStr)) {
                return item;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }
}
