/**
 *
 */
package com.cusc.nirvana.user.rnr.mg.common;


import com.alibaba.fastjson.serializer.ValueFilter;
import com.cusc.nirvana.user.rnr.mg.constants.MgLogOutputConstants;
import com.cusc.nirvana.user.util.crypt.CryptKeyUtil;

/**
 * Description: 日志输出json序列化过滤器
 * <br />
 * CreateDate 2022-05-12 16:55:45
 *
 * @author yuyi
 **/
public class MgLogOutputJsonSerializeFilter implements ValueFilter {

    @Override
    public Object process(Object object, String name, Object value) {
        // 过滤base64字段的输出
        if (MgLogOutputConstants.IGNORE_BASE64_FIELD_LIST.contains(name)) {
            return "ignore base64 string";
        }
        //隐私数据加密
        if (MgLogOutputConstants.ENCRYPTION_FIELD_LIST.contains(name)) {
            if(value != null){
                return CryptKeyUtil.encryptToBase64(value.toString());
            }
            return value;
        }

        return value;
    }

}
