package com.cusc.nirvana.user.rnr.mg.common;

import lombok.Data;

import java.io.*;

/**
 * Description: 基础响应类
 * <br />
 * CreateDate 2022-03-01 14:13:50
 *
 * @author yuyi
 **/
@Data
public class BaseRnrMgRespDTO<T> implements Serializable {

    private static final long serialVersionUID = -7559214862745743436L;

    /**
     * 交易代码，200：成功；非200：异常
     */
    private Integer code;

    /**
     * 交易结果描述 当ret_code 非200 时，存放异常信息
     */
    private String msg;

    /**
     * 流水号,直接将请求时的serial_number 返回
     */
    private String serial_number;

    /**
     * 生成结果的时间戳，UTC 时间.格式为yyyy-MM-dd HH:mm:ss 例如：2018-05-20 13:14:00
     */
    private String timestamp;

    /**
     * 响应数据
     */
    private T data;
}
