package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgReqDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Description: 个人实名认证实体DTO
 * <br />
 * CreateDate 2022-03-01 14:00:36
 *
 * @author yuyi
 **/
@Data
@ApiModel(value = "个人实名认证实体")
public class PersonalRnrDTO extends BaseRnrMgReqDTO {

    private static final long serialVersionUID = 308383184801280441L;

    @ApiModelProperty(value = "Iccid编号集合")
    private List<String> iccidList;

    @ApiModelProperty(value = "姓名")
    private String fullName;

    @ApiModelProperty(value = "证件类型")
    private String certType;

    @ApiModelProperty(value = "证件号码")
    private String certNumber;

    @ApiModelProperty(value = "证件地址")
    private String certAddress;

    @ApiModelProperty(value = "联系地址")
    private String contactAddress;

    @ApiModelProperty(value = "联系电话")
    private String phone;

    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "性别")
    private String gender;

    @ApiModelProperty(value = "证件正面")
    private String certFrontPic;

    @ApiModelProperty(value = "证件反面")
    private String certBackPic;

    @ApiModelProperty(value = "手持证件照")
    private String faceCertPic;

    @ApiModelProperty(value = "网文照/芯片照")
    private String baseImg;

    /**
     * 实名图片
     */
    @ApiModelProperty(value = "实名图片")
    private List<MgRnrFileDTO> rnrImageList;

    @ApiModelProperty(value = "业务区分")
    private String channelId;

    /**
     * 实名标签
     */
    @ApiModelProperty(value = "实名标签")
    private List<MgRnrTagDTO> rnrTagList;

    /**
     * 联系人信息集合
     */
    @ApiModelProperty(value = "联系人信息集合")
    private List<MgRnrLiaisonInfoDTO> rnrLiaisonList;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "操作人")
    private String operator;

    //系统信息
    @ApiModelProperty(value = "订单延迟配置")
    private String orderDelay;
}
