package com.cusc.nirvana.user.rnr.mg.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.cusc.nirvana.user.rnr.mg.validation.group.Delete;
import com.cusc.nirvana.user.rnr.mg.validation.group.Insert;
import com.cusc.nirvana.user.rnr.mg.validation.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@ApiModel(value = "组织所拥有的车卡关系DTO", description = "")
@Data
public class OrgSimVehicleRelDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "业务UUID", example = "10000")
    @NotNull(message = "业务uuid不能为空", groups = {Update.class, Delete.class})
    private String uuid;

    @ApiModelProperty(value = "组织业务UUID", example = "10000")
    @NotNull(message = "组织业务UUID不能为空", groups = {Insert.class, Update.class, Delete.class})
    private String orgUuid;

    @ApiModelProperty(value = "SIM卡的iccid")
    @NotNull(message = "iccid不能为空", groups = {Insert.class})
    private String iccid;

    @ApiModelProperty(value = "车辆vin号")
    private String vin;

    @ApiModelProperty(value = "是否删除, 0:否, 1:是")
    private Integer isDelete = 0;

    @ApiModelProperty(value = "创建时间")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    @ApiModelProperty(value = "修改时间")
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    @ApiModelProperty(value = "创建人")
    private String creator;


    /**车辆的一个号  郝岩加  小鹏 */
    @ApiModelProperty(value = "车辆的msisdn号")
    private String msisdn;
    /**绑定状态  郝岩加  小鹏 */
    @ApiModelProperty(value = "卡的绑定状态")
    private String bindingStatus;
    /**运营商编码  郝岩加  小鹏 */
    @ApiModelProperty(value = "运营商编码")
    private String mbCode;
}
