package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.Date;

@ApiModel(value = "OrgSimRelQueryDTO对象", description = "查询参数对象")
@Data
public class OrgSimRelQueryDTO extends BaseRnrMgPageDTO {

    /**组织uuid*/
    @ApiModelProperty(value = "组织uuid, 为必填项", required = true)
    @NotNull(message = "业务uuid不能为空")
    private String orgUuid;

    /**业务标签*/
    @ApiModelProperty(value = "业务标签", required = false)
    private String tagUuid;

    /**VIN码*/
    @ApiModelProperty(value = "VIN码")
    private String vin;

    @ApiModelProperty(value = "车卡绑定状态")
    private Integer bindStatus;

    /**iccid*/
    @ApiModelProperty(value = "iccid", required = false)
    private String iccid;

    /**查询开始时间*/
    @ApiModelProperty(value = "查询开始时间，非必填", required = false)
    private Date startCreateTime;

    /**查询结束时间*/
    @ApiModelProperty(value = "查询结束时间, 非必填", required = false)
    private Date endCreateTime;

}
