package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.validation.group.Delete;
import com.cusc.nirvana.user.rnr.mg.validation.group.Insert;
import com.cusc.nirvana.user.rnr.mg.validation.group.Query;
import com.cusc.nirvana.user.rnr.mg.validation.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.Date;

@ApiModel(value = "OrgBusinessTagDTO对象", description = "")
@Data
public class OrgBusinessTagDTO {

    private Long id;

    /**业务主键*/
    @ApiModelProperty(value = "业务UUID", example = "10000")
    @NotNull(message = "业务uuid不能为空", groups = {Update.class, Delete.class})
    private String uuid;

    /**租户编码*/
    @ApiModelProperty(value = "租户编码", required = true)
    @NotNull(message = "租户编码不能为空", groups = {Insert.class, Update.class, Query.class})
    private String tenantNo;

    /**组织业务uuid*/
    @ApiModelProperty(value = "组织业务UUID",  required = true)
    @NotNull(message = "组织业务UUID不能为空", groups = {Insert.class, Update.class, Delete.class})
    private String orgUuid;

    /**标签编码*/
    @ApiModelProperty(value = "标签编码",  required = true)
    @NotNull(message = "标签编码不能为空", groups = {Insert.class, Update.class})
    @Length(max = 32, message = "标签名称长度不能超过32")
    private String tagCode;

    /**标签名称*/
    @ApiModelProperty(value = "标签名称",  required = true)
    @NotNull(message = "标签编码不能为空", groups = {Insert.class, Update.class})
    @Length(max = 100, message = "标签名称长度不能超过100")
    private String tagName;

    /**标签描述*/
    @ApiModelProperty(value = "标签描述",  required = true)
    @Length(max = 256, message = "标签名称长度不能超过256")
    private String description;

    /**逻辑删除（0-未删除，1-已删除）*/
    private Integer isDelete;

    /**创建时间*/
    private Date createTime;

    /**更新时间*/
    private Date updateTime;

    /**创建人*/
    private String creator;

}
