package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 开放平台租户和实名制租户映射关系表(OpenTenantRelation)传输对象类
 *
 * @author yuy336
 * @since 2022-06-15 20:03:11
 */
@ApiModel(value = "开放平台租户和实名制租户映射关系表", description = "开放平台租户和实名制租户映射关系表")
@Data
public class OpenTenantRelationDTO extends BaseRnrMgPageDTO {

    private static final long serialVersionUID = 544351817690180081L;
    
    @ApiModelProperty(value = "业务主键")
    private String uuid;
    
    @ApiModelProperty(value = "开放平台租户ID")
    private String openTenantId;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;
}

