package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 租户业务配置(MgTenantBizzConfig)传输对象类
 *
 * @author yuy336
 * @since 2022-06-14 09:32:28
 */
@ApiModel(value = "租户业务配置", description = "租户业务配置")
@Data
public class MgTenantBizzConfigDTO extends BaseRnrMgPageDTO {

    private static final long serialVersionUID = -41678933604928225L;
    
    @ApiModelProperty(value = "业务主键")
    private String uuid;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "组织id")
    private String orgId;
    
    @ApiModelProperty(value = "实名失败重试次数，大于此次数则转人工")
    private Integer rnrFailRetryCount;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;
}

