package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 实名密钥管理(MgSecretKey)传输对象类
 *
 * @author yuy336
 * @since 2022-06-01 10:49:04
 */
@ApiModel(value = "实名密钥管理", description = "实名密钥管理")
@Data
public class MgSecretKeyDTO extends BaseRnrMgPageDTO {

    private static final long serialVersionUID = 794338202344884064L;
    
    @ApiModelProperty(value = "业务主键")
    private String uuid;
    
    @ApiModelProperty(value = "组织id")
    private String orgId;
    
    @ApiModelProperty(value = "开放平台密钥")
    private String openApiKey;
    
    @ApiModelProperty(value = "租户编号")
    private String tenantNo;
    
    @ApiModelProperty(value = "最后一次操作人")
    private String operator;
}

