package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 实名联系人信息表(MgRnrLiaisonInfo)传输对象类
 *
 * @author yuy336
 * @since 2022-03-03 19:56:15
 */
@ApiModel(value = "实名联系人信息表", description = "实名联系人信息表")
@Data
public class MgRnrLiaisonInfoDTO extends BaseRnrMgPageDTO {

    private static final long serialVersionUID = -31972316716393071L;

    @ApiModelProperty(value = "业务主键")
    private String uuid;

    @ApiModelProperty(value = "实名业务主键")
    private String rnrId;

    @ApiModelProperty(value = "联系人类型：紧急联系人、代/经办人")
//    @NotNull(groups = SaveRelation.class, message = "联系人类型不能为空")
    private Integer liaisonType;

    @ApiModelProperty(value = "被委托人姓名")
    private String liaisonName;

    @ApiModelProperty(value = "被委托人证件类型")
    private String liaisonCertType;

    @ApiModelProperty(value = "被委托人证件号码")
    private String liaisonCertNumber;

    @ApiModelProperty(value = "被委托人证件地址")
    private String liaisonCertAddress;

    @ApiModelProperty(value = "被委托人通讯地址")
    private String liaisonContactAddress;

    @ApiModelProperty(value = "被委托人电话")
    private String liaisonPhone;

    @ApiModelProperty(value = "性别")
    private Integer liaisonGender;

    @ApiModelProperty(value = "证件失效时间")
    private String liaisonExpiredDate;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "分表路由键")
    private Long routingKey;

    @ApiModelProperty(value = "最后一次操作人")
    private String operator;

    @ApiModelProperty(value = "业务类型：1 实名, 2 解绑, 3 换件,  4 信息变更,5 重绑")
    private Integer rnrBizzType;
}

