package com.cusc.nirvana.user.rnr.mg.dto;

import com.cusc.nirvana.user.rnr.mg.common.BaseRnrMgPageDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 实名图片信息表(MgRnrImage)传输对象类
 *
 * @author yuy336
 * @since 2022-01-26 11:34:40
 */
@ApiModel(value = "实名图片信息表", description = "实名图片信息表")
@Data
public class MgRnrFileDTO extends BaseRnrMgPageDTO {

    private static final long serialVersionUID = 713086606910375692L;

    @ApiModelProperty(value = "业务主键")
    private String uuid;

    @ApiModelProperty(value = "实名业务主键")
    private String rnrId;

    @ApiModelProperty(value = "企业id")
    private String rnrCompanyId;

    @ApiModelProperty(value = "联系人id")
    private String liaisonId;

    @ApiModelProperty(value = "文件类型：身份证正面，身份证反面，人脸图片")
    private Integer fileType;

    @ApiModelProperty(value = "是否为企业 0 不是 1  是")
    private Integer isCompany;

    @ApiModelProperty(value = "排序")
    private Integer orderNo;

    @ApiModelProperty(value = "文件系统id")
//    @NotBlank(groups = SaveRelation.class, message = "文件系统id不能为空")
    private String fileSystemId;

    @ApiModelProperty(value = "文件base64字符串")
    private String fileBase64;

    @ApiModelProperty(value = "文件名称，包含文件格式后缀")
//    @NotBlank(groups = SaveRelation.class, message = "文件名称不能为空")
    private String fileName;

    @ApiModelProperty(value = "分表路由键")
    private Long routingKey;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "最后一次操作人")
    private String operator;

    @ApiModelProperty(value = "业务类型：1 实名, 2 解绑, 3 换件,  4 信息变更,5 重绑")
    private Integer rnrBizzType;
}

