package com.cusc.nirvana.user.rnr.mg.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author hxin
 * @date 2022/5/24 13:53
 */
@ApiModel(value = "MgCheckStatisticsQueryDTO", description = "统计看板查询参数DTO")
@Data
public class MgCheckStatisticsQueryDTO{

    @ApiModelProperty(value = "截止时间")
    private String dateTime;

    @ApiModelProperty(value = "业务类型 1 实名, 2 解绑, 3 换件,  4 信息变更,5 重绑")
    private List<Integer> rnrBizzTypeList;

    @ApiModelProperty(value = "实名状态： 0 未实名（认证中）  1 已实名  2 实名失败 3 已解绑")
    private List<Integer> rnrStatusList;

    @ApiModelProperty(value = "是否为企业 0不是 1是")
    private Integer isCompany;

    @ApiModelProperty(value = "是否车企实名 0否 1是")
    private Integer isVehicleCompany;

    @ApiModelProperty(value = "所有下级车企组织idList")
    private List<String> orgIdList;

    @ApiModelProperty(value = "租户编号")
    private String tenantNo;

    @ApiModelProperty(value = "当前用户的车企组织")
    private String userOrgId;
}
