package com.cusc.nirvana.user.rnr.mg.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Data
public class LocalVerifyPersonDetailDTO {

    @ApiModelProperty(value = "工单详情")
    private RnrOrderDetail rnrOrderDetail;

    @ApiModelProperty(value = "车卡关系")
    private List<VinCardMsg> vinCardMsg;

    @ApiModelProperty(value = "车主信息")
    private PersonMsg vinOwnerMsg;

    @ApiModelProperty(value = "代办人信息")
    private PersonMsg vinLiaisonMsg;

    @ApiModelProperty(value = "文件信息")
    private VerifyFileMsg verifyFileMsg;

    @ApiModelProperty(value = "认证信息")
    private VerifyLivingMsg verifyLivingMsg = new VerifyLivingMsg();

    @ApiModelProperty(value = "审核信息")
    private VerifyMsg verifyMsg;


    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class RnrOrderDetail {
        @ApiModelProperty(value = "经销商名称")
        private String orgName;
        @ApiModelProperty(value = "车企名称")
        private String vinCompanyName;
        @ApiModelProperty(value = "业务类型")
        private String rnrBizzName;
        @ApiModelProperty(value = "实名日期")
        private String rnrDate;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class VinCardMsg {
        @ApiModelProperty(value = "vin号")
        private String vin;
        @ApiModelProperty(value = "iccid号")
        private String iccid;
        @ApiModelProperty(value = "信息校验")
        private String status;
    }


    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class PersonMsg {
        @ApiModelProperty(value = "姓名")
        private String name;
        @ApiModelProperty(value = "性别")
        private String sex;
        @ApiModelProperty(value = "证件类型")
        private String idType;
        @ApiModelProperty(value = "证件照片人像")
        private String idImageFace;
        @ApiModelProperty(value = "证件照片国徽")
        private String idImageEmblem;
        @ApiModelProperty(value = "证件号码")
        private String idNo;
        @ApiModelProperty(value = "证件有效期")
        private String idValidDate;
        @ApiModelProperty(value = "证件地址")
        private String idAddress;
        @ApiModelProperty(value = "手机号")
        private String phone;
        @ApiModelProperty(value = "通讯地址")
        private String contactAddress;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class VerifyFileMsg {
        @ApiModelProperty(value = "委托书图片")
        private List<String> attorneyImage = new ArrayList<>();
        @ApiModelProperty(value = "购车发票图片")
        private List<String> buyBillImage = new ArrayList<>();
        ;
        @ApiModelProperty(value = "购买合同图片")
        private List<String> buyContractImage = new ArrayList<>();
        ;
        @ApiModelProperty(value = "车辆过户证明")
        private List<String> transferOwnershipProveImage = new ArrayList<>();
        @ApiModelProperty(value = "入网合同")
        private List<String> networkAccessContractImage = new ArrayList<>();
        ;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class VerifyLivingMsg {
        @ApiModelProperty(value = "人脸图片")
        private List<String> faceImage = new ArrayList<>();
        @ApiModelProperty(value = "活体认证视频")
        private String livingVideo;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class VerifyMsg {
        @ApiModelProperty(value = "当前登录用户")
        private String currentUserName;
        @ApiModelProperty(value = "当前时间")
        private String currentDate;
        @ApiModelProperty(value = "审核意见")
        private LinkedHashMap<String, String> verifySuggestion;
        @ApiModelProperty(value = "工单状态")
        private Integer orderStatus;
    }

    //---------------认证结果信息---------------------------------------------------------
    @ApiModelProperty(value = "认证结果")
    private List<EnterpriseVerifyDetailDTO.AuthResult> authResultInfo;

}
