package com.cusc.nirvana.user.rnr.mg.dto;

import lombok.Data;

import java.util.Date;

/**
 * 企业责任人变更审核返回类
 */
@Data
public class CompanyCorporationChangeRespDTO {

    private Boolean success = false;

    private Integer errorCode;

    private String errorMsg;

    /**
     * 工单信息
     */
    private OrderDto orderDto;
    /**
     * 原企业和责任人信息
     * 根据tenantNo进行查询
     */
    private OldMgRnrInfoDto oldMgRnrInfoDto;
    /**
     * 新责任人信息
     */
    private NewMgRnrInfoDto NewMgRnrInfoDto;
    /**
     * 企业实名认证授权书 文件信息
     * MgRnrFilePo rnrId为MgRnrInfoPO的uuid fileType为ENTERPRISE_AUTH_FILE(29)
     */
    private String enterpriseAuthFileForUuId;
    /**
     * 活体截图1
     * fileType为LIVENESS_SCREEN_FIRST(3)
     */
    private String livenessScreenFirstForUuId;
    /**
     * 活体视频
     * fileType为LIVENESS_VIDEO(6)
     */
    private String livenessVideoForUuId;


    /**
     * 工单信息实体类
     */
    @Data
    public static class OrderDto {

        /**
         * 业务类型
         * RnrOrderPO 的 orderType
         */
        private String orderType;

        /**
         * 经销商名称
         * RnrOrderPO的orgId查询eiam_organization
         */
        private String organName;

        /**
         * 车企名称
         * RnrOrderPO的rnr_id查询mg_rnr_company_info的rnr_id
         */
        private String companyName;

        /**
         * 实名日期
         * RnrOrderPO的rnr_id查询mg_rnr_info的uuid
         */
        private Date updateTime;

        /**
         * 业务类型
         * RnrOrderPO 的 order_status
         */
        private Integer orderStatus;
    }

    /**
     * 原企业和责任人信息
     */
    @Data
    public static class OldMgRnrInfoDto {
        /**
         * 责任人姓名
         */
        private String fullName;
        /**
         * 企业名称
         */
        private String companyName;
    }

    /**
     * 新责任人信息
     */
    @Data
    public static class NewMgRnrInfoDto {
        /**
         * 自然人姓名
         */
        private String fullName;
        /**
         * 性别
         */
        private Integer gender;
        /**
         * 证件类型
         */
        private String certType;
        /**
         * 证件号
         */
        private String certNumber;
        /**
         * 证件失效时间
         */
        private String expiredDate;
        /**
         * 证件地址
         */
        private String certAddress;
        /**
         * 手机号
         */
        private String phone;
        /**
         * 联系地址
         */
        private String contactAddress;
        /**
         * 身份证人像面
         */
        private String identityCardBackForUuId;
        /**
         * 身份证国徽面
         */
        private String identityCardFrontForUuId;
    }

}
