package com.cusc.nirvana.user.rnr.mg.constants;

/**
 * Description: 实名订单审核类型
 * <br />
 * CreateDate 2022-03-03 10:08:34
 *
 * @author yuyi
 **/
public enum RnrOrderAuditTypeEnum {

    AUTO(0, "自动"),
    MANUAL(1, "手动");
    private Integer type;
    private String comment;

    RnrOrderAuditTypeEnum(Integer type, String comment) {
        this.type = type;
        this.comment = comment;
    }

    public static RnrOrderAuditTypeEnum getDescription(Integer key) {
        for (RnrOrderAuditTypeEnum type : values()) {
            if (type.type.equals(key)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return type;
    }

    public String getComment() {
        return comment;
    }
}
