package com.cusc.nirvana.user.rnr.mg.constants;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author stayAnd
 * @date 2022/4/25
 */
@AllArgsConstructor
@Getter
public enum  GenderEnum {
	/**
	 * MALE
	 */
	MALE(1,"男"),

	FEMALE(2,"女"),

	UNKOWN(0,"未知")
	;

	private Integer code;

	private String name;



	public static GenderEnum findByName(String genderName){
		return Arrays.stream(GenderEnum.values()).filter(genderEnum -> genderEnum.getName().equals(genderName)).findFirst().orElse(GenderEnum.UNKOWN);
	}

	public static GenderEnum findByCode(Integer code){
		return Arrays.stream(GenderEnum.values()).filter(genderEnum -> genderEnum.getCode() == code).findFirst().orElse(GenderEnum.UNKOWN);
	}

	public static String findNameByCode(Integer code){
		for (GenderEnum sys : GenderEnum.values()) {
			if (sys.getCode() == code) {
				return sys.name;
			}
		}
		return null;
	}
}
