package com.cusc.nirvana.user.rnr.mg.constants;

import com.cusc.nirvana.common.tool.url.StringUtils;

public enum CompanyTypeEnum {
    GYQY(0, "国有企业"),
    JTSYZ(1, "集体所有制"),
    SYQY(2, "私营企业"),
    YXZRGS(3, "有限责任公司"),
    GFYXGS(4, "股份有限公司"),
    YXHHQY(5, "有限合伙企业"),
    LYQY(6, "联营企业"),
    WSTZQY(7, "外商投资企业"),
    GRDZQY(8, "个人独资企业"),
    QT(9, "其他");

    private int code;
    private String value;

    CompanyTypeEnum(int code, String value) {
        this.code = code;
        this.value = value;
    }

    public static CompanyTypeEnum getEnumByCode(int code) {
        for (CompanyTypeEnum item : CompanyTypeEnum.values()) {
            if (item.getCode() == code) {
                return item;
            }
        }
        return null;
    }

    public static CompanyTypeEnum getEnumByCode(String codeStr) {
        if (StringUtils.isBlank(codeStr)) {
            return null;
        }
        for (CompanyTypeEnum item : CompanyTypeEnum.values()) {
            if (item.getCode() == Integer.parseInt(codeStr)) {
                return item;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getValue() {
        return value;
    }
}
