package com.cusc.nirvana.user.rnr.mg.constants;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author stayAnd
 * @date 2022/4/25
 * CertTypeEnum ----> RnrFileType
 */
@AllArgsConstructor
@Getter
public enum CertFileRnrFileTypeRelation {
	/**
	 * 身份证
	 */
	IDCARD_RELATION(CertTypeEnum.IDCARD,Arrays.asList(RnrFileType.IDENTITY_CARD_BACK,RnrFileType.IDENTITY_CARD_FRONT)),

	/**
	 * 港澳居民来往内地通行证
	 */
	HKIDCARD_RELATION(CertTypeEnum.HKIDCARD,Arrays.asList(RnrFileType.HK_MACAO_PASSPORT_FRONT,RnrFileType.HK_MACAO_PASSPORT_BACK)),

	/**
	 * 护照
	 */
	PASSPORT_RELATION(CertTypeEnum.PASSPORT,Arrays.asList(RnrFileType.FOREIGN_NATIONAL_PASSPORT_FRONT,RnrFileType.FOREIGN_NATIONAL_PASSPORT_BACK)),

	/**
	 * 军官证
	 */
	PLA_RELATION(CertTypeEnum.PLA,Arrays.asList(RnrFileType.OFFICIAL_CARD_FRONT,RnrFileType.OFFICIAL_CARD_BACK)),

	/**
	 * 警官证
	 */
	POLICEPAPER_RELATION(CertTypeEnum.POLICEPAPER,Arrays.asList(RnrFileType.POLICE_CARD_FRONT,RnrFileType.POLICE_CARD_BACK)),

	/**
	 * 台湾居民来往大陆通行证
	 */
	TAIBAOZHENG_RELATION(CertTypeEnum.TAIBAOZHENG,Arrays.asList(RnrFileType.TAIWAN_CARD_FRONT,RnrFileType.TAIWAN_CARD_FRONT)),

	/**
	 * 社会统一信用代码
	 */
	UNITCREDITCODE_RELATION(CertTypeEnum.UNITCREDITCODE, Collections.singletonList(RnrFileType.UNITCREDITCODE))
	;

	private CertTypeEnum certTypeEnum;

	private List<RnrFileType> rnrFileTypeList;

	public static  List<RnrFileType> getRnrFileList(CertTypeEnum certTypeEnum){
		CertFileRnrFileTypeRelation certFileRnrFileTypeRelation = Arrays.stream(CertFileRnrFileTypeRelation.values()).filter(r -> r.getCertTypeEnum().getCode().equals(certTypeEnum.getCode())).findFirst().orElse(null);
		if (null == certFileRnrFileTypeRelation) {
			return Arrays.asList(RnrFileType.OTHER);
		}
		return certFileRnrFileTypeRelation.getRnrFileTypeList();
	}

}
