/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.fp.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.dto.BindRequestDTO;
import com.cusc.nirvana.user.rnr.fp.dto.IccidDetailDTO;
import com.cusc.nirvana.user.rnr.fp.dto.IccidListDTO;
import com.cusc.nirvana.user.rnr.fp.dto.ImportSimParamDTO;
import com.cusc.nirvana.user.rnr.fp.dto.ImportSimResult;
import com.cusc.nirvana.user.rnr.fp.dto.SimVehicleBindingDTO;
import com.cusc.nirvana.user.rnr.fp.dto.SimVehicleBindingResult;
import com.cusc.nirvana.user.rnr.fp.dto.SimVehicleDTO;
import com.cusc.nirvana.user.rnr.fp.dto.SimVehicleQueryDTO;
import com.cusc.nirvana.user.rnr.fp.dto.SimVehicleResultDTO;
import com.cusc.nirvana.user.rnr.fp.dto.VinIccidDTO;
import com.cusc.nirvana.user.rnr.mg.util.RnrMgRestTemplateUtils;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class SimVehicleRelClient {
    private static final String IMPORT_SIM_URL = "http://local-rnr-fp/simvehcilerel/importSim";
    private static final String IMPORT_SIM_VEHICLE_URL = "http://local-rnr-fp/simvehcilerel/importSimVehicle";
    private static final String GET_ICCID_BY_VIN_URL = "http://local-rnr-fp/simvehcilerel/getIccidByVin";
    private static final String GET_BINDING_STATUS_URL = "http://local-rnr-fp/simvehcilerel/queryByIccids";
    private static final String QUERY_BY_ICCIDS_URL = "http://local-rnr-fp/simvehcilerel/queryByIccids";
    private static final String QUERY_SIM_VEHICLE_PAGE_URL = "http://local-rnr-fp/simvehcilerel/querySimVehiclePage";
    private static final String UN_BIND_URL = "http://local-rnr-fp/simvehcilerel/unbind";
    @Autowired
    @Qualifier(value="restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    public Response<ImportSimResult> importSim(ImportSimParamDTO importSimParamDTO) {
        return RnrMgRestTemplateUtils.postForResponse((RestTemplate)this.restTemplateRnrFp, (String)IMPORT_SIM_URL, (Object)importSimParamDTO, ImportSimResult.class, (Object[])new Object[0]);
    }

    public Response<SimVehicleBindingResult> importSimVehicle(SimVehicleBindingDTO bindingDTO) {
        return RnrMgRestTemplateUtils.postForResponse((RestTemplate)this.restTemplateRnrFp, (String)IMPORT_SIM_VEHICLE_URL, (Object)bindingDTO, SimVehicleBindingResult.class, (Object[])new Object[0]);
    }

    public Response<SimVehicleDTO> unbind(BindRequestDTO requestDTO) {
        return RnrMgRestTemplateUtils.postForResponse((RestTemplate)this.restTemplateRnrFp, (String)UN_BIND_URL, (Object)requestDTO, SimVehicleDTO.class, (Object[])new Object[0]);
    }

    public Response<List<VinIccidDTO>> getIccidByVin(String vin) {
        return RnrMgRestTemplateUtils.getForResponseList((RestTemplate)this.restTemplateRnrFp, (String)("http://local-rnr-fp/simvehcilerel/getIccidByVin?vin=" + vin), VinIccidDTO.class, (Object[])new Object[0]);
    }

    public Response<VinIccidDTO> getBindingInfo(String iccid, String vin) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("iccid", iccid);
        params.put("vin", vin);
        Response response = (Response)this.restTemplateRnrFp.getForObject("http://local-rnr-fp/simvehcilerel/queryByIccids?iccid={iccid}&vin={vin}", Response.class, params);
        return Response.createSuccess((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)response.getData()), VinIccidDTO.class));
    }

    public Response<PageResult<SimVehicleResultDTO>> querySimVehiclePage(SimVehicleQueryDTO queryDTO) {
        Response response = RnrMgRestTemplateUtils.postForResponsePageResult((RestTemplate)this.restTemplateRnrFp, (String)QUERY_SIM_VEHICLE_PAGE_URL, (Object)queryDTO, SimVehicleResultDTO.class, (Object[])new Object[0]);
        return response;
    }

    public Response<List<IccidDetailDTO>> queryByIccids(IccidListDTO listDTO) {
        return RnrMgRestTemplateUtils.postForResponseList((RestTemplate)this.restTemplateRnrFp, (String)"http://local-rnr-fp/simvehcilerel/queryByIccids", (Object)listDTO, IccidDetailDTO.class, (Object[])new Object[0]);
    }
}

