/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.rnr.fp.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.rnr.fp.common.FpIgnoreBase64ImgJsonSerializeFilter;
import com.cusc.nirvana.user.rnr.fp.common.ResponseCode;
import com.cusc.nirvana.user.rnr.fp.dto.FileDownloadDTO;
import com.cusc.nirvana.user.rnr.fp.dto.FileRecordDTO;
import com.cusc.nirvana.user.rnr.fp.dto.FileUploadDTO;
import com.cusc.nirvana.user.rnr.fp.dto.ImageBase64DTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;

@Component
public class FileSystemClient {
    private static final Logger log = LoggerFactory.getLogger(FileSystemClient.class);
    @Autowired
    @Qualifier(value="restTemplateRnrFp")
    RestTemplate restTemplateRnrFp;

    public Response<FileRecordDTO> getFileSize(FileRecordDTO dto) {
        return RnrFpRestTemplateUtils.postForResponse((RestTemplate)this.restTemplateRnrFp, (String)"http://local-rnr-fp/file/getFileSize", (Object)dto, FileRecordDTO.class, (Object[])new Object[0]);
    }

    public Response<ImageBase64DTO> getBase64(FileDownloadDTO fileDownloadDTO) {
        return RnrFpRestTemplateUtils.postForResponse((RestTemplate)this.restTemplateRnrFp, (String)"http://local-rnr-fp/file/getBase64", (Object)fileDownloadDTO, ImageBase64DTO.class, (Object[])new Object[0]);
    }

    public Response<FileRecordDTO> getUrl(@RequestBody FileDownloadDTO fileDownloadDTO) {
        return RnrFpRestTemplateUtils.postForResponse((RestTemplate)this.restTemplateRnrFp, (String)"http://local-rnr-fp/file/getUrl", (Object)fileDownloadDTO, FileRecordDTO.class, (Object[])new Object[0]);
    }

    public Response uploadImage(FileUploadDTO fileUploadDTO) {
        String url = "http://local-rnr-fp/file/uploadImage";
        ResponseEntity<String> entity = this.execute(fileUploadDTO, url);
        Response response = (Response)JSONObject.parseObject((String)((String)entity.getBody()), (Type)new TypeReference<Response<FileRecordDTO>>(new Type[]{FileRecordDTO.class}){}.getType(), (Feature[])new Feature[0]);
        return response;
    }

    public Response uploadFile(FileUploadDTO fileUploadDTO) {
        String url = "http://local-rnr-fp/file/uploadFile";
        ResponseEntity<String> entity = this.execute(fileUploadDTO, url);
        Response response = (Response)JSONObject.parseObject((String)((String)entity.getBody()), (Type)new TypeReference<Response<FileRecordDTO>>(new Type[]{FileRecordDTO.class}){}.getType(), (Feature[])new Feature[0]);
        return response;
    }

    public Response<FileRecordDTO> uploadFileBase64(FileUploadDTO fileUploadDTO, String suffix) {
        String url = "http://local-rnr-fp/file/uploadFile_base64/" + suffix;
        ResponseEntity<String> entity = this.executeBase64(fileUploadDTO, url);
        Response response = (Response)JSONObject.parseObject((String)((String)entity.getBody()), (Type)new TypeReference<Response<FileRecordDTO>>(new Type[]{FileRecordDTO.class}){}.getType(), (Feature[])new Feature[0]);
        return response;
    }

    private ResponseEntity<String> execute(final FileUploadDTO fileUploadDTO, String url) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        ByteArrayResource resource = null;
        try {
            resource = new ByteArrayResource(fileUploadDTO.getFile().getBytes()){

                public String getFilename() {
                    return fileUploadDTO.getFile().getOriginalFilename();
                }
            };
        }
        catch (Exception e) {
            log.error("uploadImage error:", (Object)e.getMessage(), (Object)e);
            throw new CuscUserException(ResponseCode.SYSTEM_ERROR.getCode(), "\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
        }
        parameters.add((Object)"file", (Object)resource);
        HttpEntity httpEntity = new HttpEntity((Object)parameters, (MultiValueMap)headers);
        ResponseEntity entity = this.restTemplateRnrFp.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        log.info("FileUpload, url:{},parameter:{},response:{}", new Object[]{url, JSON.toJSONString((Object)fileUploadDTO, (SerializeFilter)new FpIgnoreBase64ImgJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]), entity.toString()});
        return entity;
    }

    private ResponseEntity<String> executeBase64(FileUploadDTO fileUploadDTO, String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)fileUploadDTO, (MultiValueMap)headers);
        ResponseEntity entity = this.restTemplateRnrFp.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
        log.info("FileUpload, url:{},parameter:{},response:{}", new Object[]{url, JSON.toJSONString((Object)fileUploadDTO, (SerializeFilter)new FpIgnoreBase64ImgJsonSerializeFilter(), (SerializerFeature[])new SerializerFeature[0]), entity.toString()});
        return entity;
    }
}

