package com.cusc.nirvana.user.rnr.fp.client;


import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.VerifyVinCardResponseDTO;
import com.cusc.nirvana.user.rnr.fp.dto.VinCardDTO;
import com.cusc.nirvana.user.rnr.fp.dto.VinCardInfoDTO;
import com.cusc.nirvana.user.rnr.fp.dto.VinCardListRequestDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author stayAnd
 * @date 2022/4/11
 */
@Component
public class VinCardClient {


    @Resource
    private RestTemplate restTemplateRnrFp;

    public Response<VinCardInfoDTO> queryVinCard(String vin) {
        return RnrFpRestTemplateUtils.getForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/vinCard/queryVinCard/" + vin, VinCardInfoDTO.class);
    }

    public Response<List<VinCardInfoDTO>> queryVinCardList(VinCardListRequestDTO dto) {
        return RnrFpRestTemplateUtils.postForResponseList(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/vinCard/queryVinCardList", dto, VinCardInfoDTO.class);
    }

    /**
     * 验证车卡关系
     *
     * @param verifyDTOs
     * @return
     */
    public Response<VerifyVinCardResponseDTO> verifyVinCard(List<VinCardDTO> verifyDTOs) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/vinCard/verifyVinCard", verifyDTOs, VerifyVinCardResponseDTO.class);
    }
}
