package com.cusc.nirvana.user.rnr.fp.client;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.rnr.fp.common.constant.UserRnrFpConstant;
import com.cusc.nirvana.user.rnr.fp.dto.VehicleUnboundVerifyRequestDTO;
import com.cusc.nirvana.user.rnr.fp.dto.VerifyVinCardResponseDTO;
import com.cusc.nirvana.user.rnr.fp.util.RnrFpRestTemplateUtils;
import com.cusc.nirvana.user.rnr.mg.dto.VehicleUnbindDTO;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;

/**
 * @author yubo
 * @since 2022-04-24 17:16
 */
@Service
public class VehicleUnboundClient {

    @Resource
    private RestTemplate restTemplateRnrFp;

    public Response<VerifyVinCardResponseDTO> verifyUnboundVinCardBatch(VehicleUnboundVerifyRequestDTO requestDTO) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/vehicle/verifyUnboundVinCardBatch", requestDTO, VerifyVinCardResponseDTO.class);
    }

    public Response batchUnbound(VehicleUnbindDTO requestDTO) {
        return RnrFpRestTemplateUtils.postForResponse(restTemplateRnrFp, UserRnrFpConstant.USER_RNR_FP_URL + "/vehicle/batchUnbound", requestDTO, Object.class);
    }
}
